Attribute VB_Name = "NetworkUser"
Option Explicit
'
'   This module will return the user name of the person who signed into
'   the system. This module should work with the Windows 95 and Windows NT
'   operating systems.
'
'   This module was tested under VB 4.0. It should work fine for any VBA
'   language.
'
''''
'
'   Declare variables needed
'
Private glngReturnStatus As Long
Private Const SUCCESS = 1&
Private Const FAILURE = 0&

Declare Function ADV_GetUserName Lib "advapi32.dll" Alias "GetUserNameA" (ByVal strUser As String, lngBuffer As Long) As Long

Function NetworkUserID() As String
'   This routine will get the name of the user signed onto the network.
'   If no username is found it will return an UnknownUser string.
'
    Dim lngBufferSize As Long
    Dim strUser As String
    
    On Error GoTo NetworkUserID_EH

    NetworkUserID = "UnknownUser"
    
    lngBufferSize = 255
    strUser = Space$(lngBufferSize)

    glngReturnStatus = ADV_GetUserName(strUser, lngBufferSize)
    If glngReturnStatus = SUCCESS Then
        strUser = Left$(strUser, lngBufferSize - 1)
    Else
        Err = glngReturnStatus
    End If
    NetworkUserID = strUser
    Exit Function

NetworkUserID_EH:
    NetworkUserID = "ErrorInCall"
    Exit Function
End Function


