Option Explicit

' Demo by Mark Gradowski  1995 , Compuserve 73023,244

' This demo saves only 256 color bitmaps that are 32 X 32 pixels as 256 color icons.
' Also the icons will not have any transparency in them.
' You'll need some kind of graphics program to crop or reduce your bitmaps to 32 X 32,
' and if they have more than 256 colors reduce them to 256 color bitmaps.
' If you want to save bitmaps with more colors you'll have to change the code.
' I found that you can reduce most 32 X 32 bitmaps to 256 colors without changing the look too much,
' so saving bitmaps with more colors would just make the file size bigger.
' The problem with 256 color icons is they only look right if your video mode is at least 32K colors.
' If your running in only 256 colors the icons will not look right.
' I've included a couple bitmaps so you can try it out.
' Hope you find this demo usefull, send me a note if you like it.


Type BITMAPINFOHEADER '40 bytes
    biSize As Long       'set to 40
    biWidth As Long      'set to 32
    biHeight As Long     'set to 64, the height of both the icon's masks
    biPlanes As Integer
    biBitCount As Integer
    biCompression As Long
    biSizeImage As Long     'set to 1152 for a 256 color icon
    biXPelsPerMeter As Long
    biYPelsPerMeter As Long
    biClrUsed As Long
    biClrImportant As Long
End Type

Type RGBQUAD      '4 Bytes
    rgbBlue As String * 1
    rgbGreen As String * 1
    rgbRed As String * 1
    rgbReserved As String * 1
End Type

Type BITMAPINFO   'Varies
    bmiHeader As BITMAPINFOHEADER
    bmiColors(255) As RGBQUAD ' Array length is arbitrary; may be changed
End Type

Type ICONDIR    '6 bytes
    idReserved As Integer  ' set to zero
    idType     As Integer  ' set to 1
    idCount    As Integer  ' # of icons

End Type

Type ICONDIRENTRY   '16 bytes
    bWidth         As String * 1
    bHeight        As String * 1
    bColorCount    As String * 1
    bReserved      As String * 1' set to zero
    wPlanes        As Integer
    wBitCount      As Integer
    dwBytesInRes   As Long    ' size of icon set to 2216 for a 256 color icon
    dwImageOffset  As Long    ' set to 22
End Type


Global in$, out$

Global bmpstr As String * 1152  ' for a 256 color icon

Global bi As BITMAPINFO


Global Const OFN_OVERWRITEPROMPT = &H2&
Global Const BLACK = &H0&
Global Const D_GRAY = &H858585
Global Const WHITE = &HFFFFFF

Function OpenBmp% (FileIn$)

Open FileIn For Binary As #1

Get #1, 15, bi

 If bi.bmiHeader.biBitCount = 8 And bi.bmiHeader.biWidth = 32 And bi.bmiHeader.biHeight = 32 Then ' make sure it's a 256 color bitmap that's 32 X 32 pixels only
     OpenBmp = True
 Else
    OpenBmp = False
    Close
    Exit Function
 End If

 Get #1, 1079, bmpstr   ' go past the BITMAPINFO and get the bitmap bytes
 Close

End Function

'This only saves a 256 color bitmap as an 256 color icon without any transparency in it.
'If you want transparency in the icon it's alot more work.
Sub SaveIcon (fileout$)
  
  Dim ic As ICONDIR
  Dim icdir As ICONDIRENTRY
  Dim fnum%

    
    bi.bmiHeader.biSize = 40
    bi.bmiHeader.biWidth = 32
    bi.bmiHeader.biHeight = 64
    bi.bmiHeader.biPlanes = 1
    bi.bmiHeader.biBitCount = 8
    bi.bmiHeader.biCompression = 0
    bi.bmiHeader.biSizeImage = 1152
    bi.bmiHeader.biXPelsPerMeter = 0
    bi.bmiHeader.biYPelsPerMeter = 0
    bi.bmiHeader.biClrUsed = 0
    bi.bmiHeader.biClrImportant = 0
   
    ic.idReserved = 0 ' set to zero
    ic.idType = 1    ' set to 1
    ic.idCount = 1    ' # of icons
   
    icdir.bWidth = Chr$(32)
    icdir.bHeight = Chr$(32)
    icdir.bColorCount = Chr$(0)
    icdir.bReserved = Chr$(0)      ' set to zero
    icdir.wPlanes = 1
    icdir.wBitCount = 8
    icdir.dwBytesInRes = 2216    ' size of icon set to 2216 for a 256 color icon
    icdir.dwImageOffset = 22   ' set to 22




    fnum = FreeFile
    Open fileout For Binary As fnum
    Put fnum, 1, ic          ' put in the ICONDIR
    Put fnum, 7, icdir       ' put in the ICONDIRENTRY
    Put fnum, 23, bi         ' put in the BITMAPINFO
    Put fnum, 1087, bmpstr   ' and last put in the bitmap bytes
    Close fnum

  

End Sub

