'See the Proc: TuneStr

Function TuneStr (index As Variant) As Variant
' TuneStr - Some sample tunes provided with VBPLAY$.VBX
' Example - paste the following code into your form:
'   VBPLAY1.Text = TuneStr(0)    'Get a random tune
'   VBPLAY1.Command = "Play"     'Play the tune
' SYNTAX:
' TuneStr(Command) - Get a Tune
' Where Command is:
'    "NumTunes"   - Return the number of tunes in TuneStr
'    "T1"         - Return the title for the 1st tune
'    "Tn"         - Return the title for the nth tune
'    0            - Return a random tune string
'    1            - Return the 1st tune string
'    n            - Return the nth tune string
'
Dim i%
Dim t1$, t2$, t3$, t4$, t$ 'For multiple tracks
Const NumTunes = 5         'Tune number of Tunes
Const V_STRING = 8         'For VarType function
Static Titles(NumTunes) As String
Titles(1) = "Joyful, Joyful (a segment, for guitar)"
Titles(2) = "Take Me Out to the Ball Game"
Titles(3) = "The Star Spangled Banner"
Titles(4) = "Hark the Herald Angels Sing (in solfa - easy to change keys!)"
Titles(5) = "Joy to the World (in solfa - easy to change keys!)"
'
' Some sample tunes to get you started.
' Sorry this is so small, just getting started.
' If you have a great tune you'd like to share (and it's not copyrighted)
' I'd be glad to add it to the file!
'
If VarType(index) = V_STRING Then
   If index = "NumTunes" Then
      TuneStr = NumTunes
      Exit Function
   End If

   i% = CInt(Mid(index, 2))
   TuneStr = Titles(i%)
   Exit Function
End If

Randomize
If index = "0" Or index > CVar(NumTunes) Then
   index = Int(NumTunes * Rnd + 1)
End If
Select Case index
   Case "1"
      'Joyful, Joyful, 3 tracks for guitar (use midi mapper)
      'Measure Number
      '                          1------- 2------- 3------- 4-------
      t1$ = "T120 O3 L4 TS4/4    eefg     gfed     ccde     e.d8d2   "'Melody
      t2$ = "     O3 L4 TS4/4 _8 g-g-g-g- g-g-g-g- g-g-g-g- g-_g-g-  "'Drone Note
      t3$ = "     O3 L4 TS4/4    c-e-c-e- b-d-b-d- a-e-a-e- g-d-g-d- "'Bass line
      TuneStr = t1$ + " | " + t2$ + " | " + t3$
   Case "2"
      'Take Me Out to the Ball Game - three tracks
      'Measure Number                                                                           1     1     1     1       1    1    1     1      1      1    2    2    2     2      2      2   2      2         2    2         3             3    3       3            3         3     3
      '                       1--------- 2------------- 3--- 4--- 5--- 6------ 7---- 8---- 9--- 0---- 1---- 2---- 3------ 4--- 5--- 6---- 7----- 8----- 9--- 0--- 1--- 2---- 3----- 4----- 5-- 6----- 7-------- 8--- 9-------- 0------------ 1--- 2------ 3----------- 4-------- 5---- 6------
      t1$ = "T240 O3 L4 TS3/4 c+2.       c+2.           c+ba gfd  c_c+ age     g2.   d2.   c2c+ age   g2.t  g2_   ag#a    efg  a2f  d2.   a2a    abc+   d+ba ged  c2c+ age   g2.    d2d    c2d efg    a2.t      aab  c+2.      c+2.          c+ba gf#g    a2.          b2.       c+2.  O4c+__"
      t2$ = "     O3 L4 TS3/4 f'f8'f8'f' f#'f#8'f#8'f#' g__  b-2. __g  _cc     _b-b- _b-b- __c  _cc   _b-b- b-ca* c#b#-c# c#de f2d  d2.   _f#f#  f#f#f# fff  f__  ___  _cc   _b-b-  b-cd   ___ b*-2.  _f8'f8'f' fff  ff8'f8'f' f#f#8'f#8'f#' g__  ccc     _f#8'f#8'f#' _g8'g8'g' g2.   g+__  "
      t3$ = "     O3 L4 TS3/4 a-2.       a*-2.          g-__ f-2. c-__ O2g-__  d__   g-__  c__  g-__  d__   g-__  a-2.    a-2. d-2_ a-2_  d-2_   d-2_   g-2. g-__ c__  g-__  d-__   g-a-b- c__ c-d-e- f-__      f-__ a-2.      a*-2.         g-2. d-d#-e- d-2.         g-2.      cg-e- c-__  "
      t$ = t1$ + " | " + t2$ + " | " + t3$
      TuneStr = t$
   Case "3"
      'The Star Spangled Banner
      'Measure Number                                                                                                  1       1           1      1       1        1         1     1          1                                           1                                    2                                    2                                    2             2           2      2                 2          2         2                 2           3               3         3         3
      '                       1--------- 2------------- 3---------- 4----- 5------ 6------- 7-------- 8---- 9--------- 0------ 1---------- 2----- 3------ 4------- 5-------- 6---- 7--------- 8------------------------------------------ 9----------------------------------- 0----------------------------------- 1----------------------------------- 2------------ 3---------- 4----- 5---------------- 6--------- 7-------- 8---------------- 9---------- 0-------------- 1-------- 2-------- 3-----------
      t1$ = "T120 O3 L4 H2 TS3/4 f8.td16    b*-df          b*2d+8.c+16 b*de   f2f8f8  d+.c+8b* a2g8a8    b*b*f db*-f8.d16 b*-df   b*2d+8.c+16 b*de   f2f8f8  d+.c+8b* a2g8a8    b*b*f db*-d+8d+8 d+e*+f+                                     f+2e*+8d+8                           c+d+e*+                              e*+2e*+                              d+.c+8b*      a2g8.a16    b*de   f2f8tf8           b*b*b*8ta8 ggg       c+e*+8td+8c+8tb*8 b*tahf8f8   b*.tc+8d+8e*+8  f+2b*8c+8 d+.e*+8c+ b*2          "
      t2$ = "T120 O3 L4 H2 TS3/4 _          _2.            d2d8.d16    ddc    c2f8f8  f.f8f    f2f8f8    _2.   _2.        _2.     d2d8.d16    ddc    c2f8f8  f.f8f    f2f8f8    _2.   _2b*8b*8   b*c+d+                                      d+2c+8b*8                            ab*c+                                c+2a                                 f.f8f         f2f8.f16    fdc    c2f8tf8           de*f       e*e*f     e*e*8tf8g         ftfhf8f8    f2f8b*8         b*2g8e8   f.g8e*    d2           "
      t3$ = "T120 O2 L4 H2 TS3/4 f8.td16    b*-b*c+        b*2a8.a16   b*b*b* a2f8f8  b*.a8b*  c+2c+8c+8 b*b*f db*-f8.d16 b*-b*c+ b*2a8.a16   b*b*b* a2f8f8  b*.a8b*  c+2c+8c+8 b*b*f db*-_      MLO1L32b-bb-bb-bb-bb-bb-bb-bb-bb-bb-bb-bb-b b-bb-bb-bb-bb-bb-bb-bb-bb-bb-bb-bb-b ff+ff+ff+ff+ff+ff+ff+ff+ff+ff+ff+ff+ ff+ff+ff+ff+ff+ff+ff+ff+ff+ff+ff+ff+ MNO2L4b*.a8b* c+2c+8.c+16 b*b*b* f8tg8tf8te*8d8tc8 b*b*b*     b*b*b     c+g8td8e*+8td+8   d+tc+hd8td8 b*.tc+8d+8e*+8  d+2d+8b*8 b*.b*8a   b*2          "
      t4$ = "T120 O2 L4 H2 TS3/4 _          _2a            g2f#8.f#16  ggc    f2f8f8  b*-.c8d  f2e*8e*8  d__   _2.        __a     g2f#8.f#16  ggc    f2f8f8  b*-.c8d  f2e*8e*8  d__   _2.        b*-2.t                                      b*-2.                                f-2.t                                f-2.                                 b*-.c8d       f2e*8.e*16  dgc    _2.               b*-cd      e*e*d     cc8td8e*8te8      ftfhf8te*8  d.tf8b*8tg8     d2g8g8    f.f8f     b*-2         "
      t$ = t1$ + " | " + t2$ + " | " + t3$ + " | " + t4$
      TuneStr = t$
   Case "4"
      'Hark the Herald Angels Sing
      t1$ = "T100 O3 L4 KG TS4/4 NS s-dd.t-8   dmmcr   sss.f8   mrm2 s-dd.t-8   dmmcr   srr.t-8   t-l-s-2 sssd   fmmcr   sssd   fmmcr llls   fmf2   rm8cf8s.d8   drm2 l.l8ls   fmf2   rm8cf8s.d8   drd2"
      t2$ = "T100 O3 L4 KG TS4/4 NS s-s-s-.s-8   s-ddct-   dt-l-r   dt-d2 s-s-s-.s-8   m-dd2   t-l-t-.s-8   s-f#-s-2 s-s-s-d   rddct-   s-s-s-d   rddct- fffm   rd#r2   t-t-d.s-8   s-t-d2 fffm   rd#r2   s-t-d.s-8   s-s-s-2"
      t3$ = "T100 O2 L4 KG TS4/4 NS mmm.r8   dss2   ssll   sss2 mmm.r8   dsl2   mrr.r8   mdt-2 ssss   sss2   ssss   sss2 llll   lll2   sss.m8   mfm2 llls   fmf2   sss.m8   mfm2 "
      t4$ = "T100 O2 L4 KG TS4/4 NS ddds-   m-d-s-2   m-m-f-f-   s-s-d-2 ddds-   l-s-f#-2   O1mf#st-  O2d-r-s-2 sssm   t-ds-2   sssm   t-ds-2 f-f-f-f-   f-l-r2   ffmd   s-s-d-2 fffm   rd#rcd   t-fmd   s-s-d2"
      t$ = t1$ + " | " + t2$ + " | " + t3$ + " | " + t4$
      TuneStr = t$
   Case "5"
      'Joy to the World
      t1$ = "T100 O3 L4 KD TS2/4 NS d+t8.l16   s.f8   mr   d.s8   l.l8   t.t8   d+.d+8 d+8ct8l8cs8   s8.cf16m8d+8   d+8ct8l8cs8   s8.cf16cm8m8   m8m8m8m16cf16   s.f16cm16 r8r8r8r16cm16   f.m16cr16   d8cd+l8   s8.cf16cm8f8   mr   d2"
      t2$ = "T100 O3 L4 KD TS2/4 NS ms8.f16   m.r8   dt-   d.d8   f.f8   r.r8   m.m8 m8cs8f8cm8   m8.cr16d8m8   m8cs8f8cm8   m8.cr16d8d8   d8d8d8d16cr16   m.r16cd16 t-8t-8t-8t-16cd16   r.d16ct-16   d8cmf8   m8.cr16cd8r8    dt-   d2"
      t3$ = "T100 O3 L4 KD TS2/4 NS dd8.d16   d.l-8   s-.f-8   m-.d8   d.d8   s-.s-8   s-._8 _2   _2   _2   _2   __8s-8   s-8s-8s-8s-8 s-2c   s-.s-16cf-16   m-8cs-d8   d.l-8   s-s-8cf-8   m-2 "
      t4$ = "T100 O2 L4 KD TS2/4 NS dd8.d16   d.f-8   s-s-   d.m8   f.f8   s.s8   d._8 _2   _2   _2   _2   __8d8   d8d8d8d8 s.s-8   s-8s-8s-8s-8   d.d8   d.f-8   s-s-   d2 "
      t$ = t1$ + " | " + t2$ + " | " + t3$ + " | " + t4$
      TuneStr = t$
End Select

End Function

