//Program that demostrates a function that will convert lengthy integers
//and floating point numbers into number strings formatted with commas

//By Ben Watson: 100711.3076@compuserve.com

#include <stdio.h>
#include <conio.h>
#include <string.h>

#define DEFAULT_DIGITS 5
#define DEFAULT_PRECISION 3

//function prototypes
char *IntString(unsigned long n);
char *DoubleString(double n,int numdig,int numdec);

main()
{
	//place to store formatted number
	char temp[30];
	unsigned long d=0;
	int n1,n2;
	double f=0.0;
	clrscr();
	//Example 1:Integer
	printf("Enter an integer: ");
	scanf("%lu",&d);
	strcpy(temp,IntString(d));
	printf("d == %s\n",temp);

	//Example 2:Floating-point
	printf("Enter a floating-point number: ");
	scanf("%lf",&f);
	strcpy(temp,DoubleString(f,DEFAULT_DIGITS,DEFAULT_PRECISION));
	printf("f == %s\n",temp);

	//Example 3: Application (very simple)
	printf("Make them over 10,000 for a good demo!\n");
	printf("Enter an integer: ");
	scanf("%d",&n1);
	printf("Enter another integer: ");
	scanf("%d",&n2);

	printf("Using the OLD way:\n");
	printf("%d x %d == %lu\n",n1,n2,(unsigned long)(n1*n2));

	printf("--OR--");

	printf("Using the new, cool way:\n");
	strcpy(temp,IntString((unsigned long)n1));
	printf("%s x ",temp);
	strcpy(temp,IntString((unsigned long)n2));
	printf("%s == ",temp);
	strcpy(temp,IntString((unsigned long)(n1*n2)));
	printf("%s\n",temp);
getch();
return 0;
}

char *IntString(unsigned long n)
{
	char temp[30];
	int index,counter,numsize;
	//convert number to string
	sprintf(temp,"%lu",n);
	//get number of digits in number
	numsize=strlen(temp);
	//Insert commas into string ever three places
	index=numsize;
	while (index>=0) {
		  index-=3;
		  numsize+=1;
		  //make sure this is a valid place to insert comma
		  if (index>=1) {
		  for (counter=numsize;counter>index;counter--) {
			  temp[counter]=temp[counter-1];
			  }
		  temp[index]=',';
		  }//end if(index)
		  }//end while
return temp;
}

char *DoubleString(double n,int numdig,int numdec)
{
	/*Works essentially the same but formats number
		according to arguments: the number of digits to
		the right and left of the decimal point
	*/
	char temp[30];
	//				  size w/o dec, size w/decimal
	int index=0,counter=0,numsize=0,entirenumsize=0;
	sprintf(temp,"%*.*f",numdig,numdec,n);
	entirenumsize=strlen(temp);

	//set length of number to number of place before decimal point
	//everything else doesn't matter
	while (temp[++numsize]!='.');

	//Insert commas into string every three places
	//start at end
	index=numsize;
	while (index>=0) {
		  //move back three places
		  index-=3;
		  //increment both number lengths by one
		  numsize++;
		  entirenumsize++;

		  if (index>=1) {
		  for (counter=entirenumsize;counter>index;counter--) {
			  temp[counter]=temp[counter-1];
			  }
		  temp[index]=',';
		  }//end if(index)
		  }//end while
return temp;
}