/***************************************************************

   Copyright 1993  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   NetCom.h

   Public definitions for applications that use the NetCom 
   control.

    - Messages
    - Notification codes.
    - Control Styles.

****************************************************************/
   
   // Useful constants
#define MAXNETNAME      16       // Max netbios name length

   // Messages the application can send to the control
#define NCM_SETCOMMAND           (WM_USER+1)
#define NCM_SETNAME              (WM_USER+2)
#define NCM_SETDATA              (WM_USER+3)
#define NCM_SETREMOTENAME        (WM_USER+5)
#define NCM_SETTRACE             (WM_USER+6)
#define NCM_SETSESSION           (WM_USER+7)
#define NCM_SETADAPTER           (WM_USER+8)
#define NCM_SETSENDTIMEOUT       (WM_USER+9)
#define NCM_SETRECTIMEOUT        (WM_USER+10)
#define NCM_GETPROPERTY          (WM_USER+11)

   // Commands specified in wParam of the NCM_SETCOMMAND message
   // Commands
#define NCC_INIT              1
#define NCC_REGISTERNAME      2
#define NCC_REGISTERGROUP     3
#define NCC_SENDDATAGRAM      4
#define NCC_RECEIVEDATAGRAM   5
#define NCC_CALL              6
#define NCC_LISTEN            7
#define NCC_SEND              8
#define NCC_RECEIVE           9
#define NCC_HANGUPONREC       10
#define NCC_HANGUPONSEND      11
#define NCC_CANCELALL         12
#define NCC_RESET             13
#define NCC_DELETENAME        14
#define NCC_RECEIVEANY        15
#define NCC_ADAPTERSTATUS     16
#define NCC_LISTNAMES         17
#define NCC_RECSESSSTATUS     18
#define NCC_SENDSESSSTATUS    19
#define NCC_RECEIVEBROADCAST  20
#define NCC_SENDBROADCAST     21
#define NCC_RECEIVEANYFORANY  22

   // wParam arguments for the NCM_SETSESSION message
#define RECEIVESESSION        0
#define SENDSESSION           1

   // Properties used in wParam of the NCM_GETPROPERTY message
#define NC_PROP_NETNAME       0
#define NC_PROP_NETDATA       1
#define NC_PROP_NETTRACE      2
#define NC_PROP_SENDSESSION   3
#define NC_PROP_ADAPTER       4
#define NC_PROP_REMOTENAME    5
#define NC_PROP_NAMENUMBER    6
#define NC_PROP_RECSESSION    7
#define NC_PROP_SESSIONSTATUS 8
#define NC_PROP_PERMNAME      9
#define NC_PROP_SENDTIMEOUT   10
#define NC_PROP_RECTIMEOUT    11
#define NC_PROP_NETERROR      12

   // Notifications sent to the application
#define NCN_RECEIVEDDATAGRAM        1
#define NCN_RECEIVEDDATA            2
#define NCN_SENDCOMPLETE            3
#define NCN_NEWSENDSESSION          4
#define NCN_NETNAME                 5
#define NCN_NEWRECSESSION           6
#define NCN_SESSIONCLOSED           7
#define NCN_SESSIONERROR            8

   // The one callable function to force the DLL to load
void FAR PASCAL registerNetCom(void);

   // High level Error codes
#define VBERRB                   32000
#define VBERR_ADDGROUP           (VBERRB)     // - Failed to add a group name
#define VBERR_ADDNAME            (VBERRB+1)   // - Failed to add a unique name
#define VBERR_UNK                (VBERRB+2)   // - Unknown error
#define VBERR_INITFAIL           (VBERRB+3)   // - Failed to initialize the NetBIOS
#define VBERR_DUPNAME            (VBERRB+4)   // - Duplicate name
#define VBERR_BADRESET           (VBERRB+5)   // - Adapter reset failed
#define VBERR_MEMALLOC           (VBERRB+6)   // - Memory allocation failure
#define VBERR_SESSSTATUS         (VBERRB+7)   // - Session status command failed
#define VBERR_TIMEOUT            (VBERRB+8)   // - Command timed out
#define VBERR_NONIBS             (VBERRB+9)   // - No network information blocks available
#define VBERR_NONETBIOS          (VBERRB+10)  // - Netbios is not installed
#define VBERR_NONAME             (VBERRB+11)  // - Specified name not found
#define VBERR_NOSESSION          (VBERRB+12)  // - Specified session number is invalid

   // Low level NetBIOS error codes 
   //
   // For the VBX control, these are the values in the NetError property.
   //
   // For the Custom Control, these are obtained by sending the
   //  NCM_GETPROPERTY message with wParam set to NC_PROP_NETERROR.


#define NRC_OK							0x00     // Success
#define NRC_ILGBUFLEN				0x01     // Invalid buffer length
#define NRC_ILGCMD					0x03     // Invalid command
#define NRC_TIMEOUT					0x05     // Timeout
#define NRC_BUFSIZE					0x06     // Invalid buffer size (same as 01)
#define NRC_ILGSESSNUM				0x08     // Invalid session number
#define NRC_SESSFULL					0x09     // No more session numbers allowed
#define NRC_SESSCLOSED				0x0A     // Session is closed
#define NRC_CMDCANCELLED			0x0B     // Command was cancelled
#define NRC_LDUPNAME					0x0D     // Duplicate name
#define NRC_NTFULL					0x0E     // Name table is full
#define NRC_SESSACT					0x0F     // Session is active
#define NRC_STFULL					0x11     // Session table is full
#define NRC_NOLISTEN					0x12     // Listen has not been established
#define NRC_ILGNAMENUM				0x13     // Invalid name number
#define NRC_NORESP					0x14     // No response
#define NRC_ILGNAME					0x15     // Illegal NetBIOS name
#define NRC_RDUPNAME					0x16     // Duplicate NetBIOS name
#define NRC_NAMEDEL					0x17     // Name has been deleted
#define NRC_ABNZ						0x18     // Buffer not terminated
#define NRC_NAMECONFL				0x19     // Name is invalid
#define NRC_BUSY						0x21     // NetBIOS is busy
#define NRC_TOOMANYCMDS				0x22     // No more commands accepted
#define NRC_ILGADPNUM				0x23     // Invalid adapter number
#define NRC_CANCELLED				0x24     // Command has been cancelled
#define NRC_NOCANCEL					0x26     // Cannot cancel command
#define NRC_OPINCL					0xFF     // Operation not yet completed


   // Data types

   // Data received information block
typedef struct
{
   LPSTR     lpData;
   WORD      nLen;
   char      szFrom[MAXNETNAME+1];
} RECINFOSTRUCT, FAR *LPRECINFOSTRUCT;

   // Session information block
typedef struct
{
   WORD      nSessionNumber;
   WORD      nSessionState;
   char      szLocalName[MAXNETNAME+1];
   char      szRemoteName[MAXNETNAME+1];
} SESSIONINFOSTRUCT, FAR *LPSESSIONINFOSTRUCT; 

   // The net names callback function
typedef BOOL (FAR PASCAL* NAMECALLBACK)(LPSTR,int);

   // Session information callback function
typedef BOOL (FAR PASCAL* SESSIONCALLBACK)(LPSESSIONINFOSTRUCT);


    
