
// Matv - A Simple Matrix Class

// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.

// test driver for complex numbers

// make sure to define USE_COMPLEX globally
#include "matv.h"
#include "conio.h"


void TestArithOperators(void)
{
  Matrix a = Fill(5, 5, complex(0.5, 2));
  Matrix b = Fill(5, 5, complex(2, 2));
  complex five = complex(5, 0);
  
  cout << "a+b" << (a + b);
  cout << "a+5" << (a + five);
  cout << "5+a" << (five + a);
  cout << "a-b" << (a - b);
  cout << "a-5" << (a - five);
  cout << "5-a" << (five - a);
  cout << "-a" << - a;
  cout << "a*b" << a*b;
  cout << "a*5" << a*five;
  cout << "5*a" << five*a;
  cout << "a%b" << a % b;
  cout << "a%5" << a % five;
  cout << "5%a" << five % a;
  cout << "a/b" << a / b;
  cout << "a/5" << a / five;
  cout << "5/a" << five / a;
}

void TestArithAssignments(void)
{
  Matrix a = Fill(5, 5, complex(0.5, - 0.5));
  Matrix b = Fill(5, 5, complex(2, 3));
  Matrix t = a;
  complex five = complex(5, 0);
  a += b;
  cout << "a+=b" << a;
  a += five;
  cout << "a+=5" << a;
  a = t;
  
  a -= b;
  cout << "a-=b" << a;
  a -= five;
  cout << "a-=5" << a;
  a = t;
  
  a *= b;
  cout << "a*=b" << a;
  a *= five;
  cout << "a*=5" << a;
  a = t;
  
  a %= b;
  cout << "a%=b" << a;
  a %= five;
  cout << "a%=5" << a;
  a = t;
  
  a /= b;
  cout << "a/=b" << a;
  a /= five;
  cout << "a/=5" << a;
  a = t;
  t = a += b;
  cout << "addition then assignment" << t;

  Matrix k = Fill(5, 3, complex(5, 3));
  t = Fill(5, 5, complex(0.5, 2));
  a = t;
  t = a *= k;
  cout << "multiplication then assignment" << t;
}

double u()
{
    return ((double)rand())/((double)RAND_MAX);
}

void TestFFT()
{
   srand(12345);
   Matrix x(17,1);
   for (int i=1; i<=x.r; i++) x(i) = complex(u(),u());
   Matrix xfft = Fft(x);
   Matrix ifft = Fft(xfft,FFALSE);
   cout << "x, ifft(fft(x)), fft(x)" << Ch(Ch( x, ifft ), xfft);
}

main(int argc, char *argv[])

{
  //ios::sync_with_stdio(); // Uncomment for SC++ Winc applications
  int i;
  Setwid(6);
  Setdec(2);
  #ifdef USE_EXTENDER
  Matrix ttt(5000, 1);
  for (int ii = 1; ii <= 5000; ii++) ttt(ii, 1) = complex(ii, ii);
  //cout << ttt;
  //ttt = Fill( 1,1, complex(1,1) );
  #endif
  Matrix t(2, 2);
  for (i = 1; i <= 4; i++) t(i) = complex(i, i);
  cout << t;
  Matrix x = t;
  cout << x;
  x = Fill(3, 2, complex(1, 1));
  cout << x;
  t = x;
  cout << t;
  t = x = Fill(3, 3, complex(3, 2));
  cout << x;
  cout << t;
  
  // make a matrix from an array
  complex xx[6] = { complex(0, 1), complex(1, 0),
    complex(2, 2), complex(3, 3),
    complex(4, 4), complex(5, 5)
  };
  Vector zz(6, xx);
  cout << "zz" << zz;
  t = Matrix(2, 3, xx);
  cout << "t" << t;

  //test reading and writing binary data files
  Writeb("testbinc.dat", t);
  Matrix testreadb = Readb("testbinc.dat");
  testreadb.show("binary read");

  // test array of matrices
  int n = 5;
  Matrix *c = new Matrix[n];
  for (i = 0; i < n; i++) c[i] = Fill(i + 1, i + 1, complex(i, i));
  for (i = 0; i < n; i++) cout << c[i];

  TestArithOperators();
  TestArithAssignments();
  TestFFT();


  // test matrix write
  t = Ident(5) + Fill(5, 5, complex(1, 1));
  cout << Inv(Ident(5) + Fill(5, 5, complex(1, 1)));
  cout << "t*t^-1" << t*Inv(t);
  Writea("junkc.mat", t, "I+(1,1)");
  Matrix jj = Reada("Junkc.Mat");
  cout << jj;
  return 0;
}
