// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.



#include "matv.h"
#include "rg.h"
#include "urandvec.h"

///////////////////////////////////////////////////////////////

void cmult_(double a, double b, double c, double d, double &e, double &f)
{ // complex multiplication
    e = a*c-b*d;
    f = a*d+b*c;
}

void Mult2mats(Matrix &a, Matrix &b, Matrix &c, Matrix &d, Matrix &e, Matrix &f)
{ // simple check of the inversion. skip the conformity checks.
  // complex multiply of complex matrices (e,f)=(a,b)*(c,d)

        double sumr, sumi;
        double x, y;
        e = f = Fill(a.r,a.c,0.0);
        for( int i=1; i<=a.r; i++){
          for( int j=1; j<=a.c; j++){
            sumr = sumi = 0.0;
            for( int k=1; k<=a.c; k++){
               cmult_( a(i,k), b(i,k), c(k,j), d(k,j), x, y);
               sumr +=  x;
               sumi +=  y;
            }
            e(i,j) = sumr;
            f(i,j) = sumi;
          }
        }
}


main()
{
  // make a matrix with complex eigenvalues and eigenvectors.
  Matrix AV(5,5);
  URand u(12345);
  for( int i=1; i<=AV.r; i++ )
    for( int j=1; j<=AV.r; j++) AV(i,j) = u();
  int ierr=0, matz=1;
  int n = AV.r;
  Matrix wr, wi, z;

  // wr = real part of eigenvalues nx1
  // wi = imaginary part of eigenvalues nx1
  // z = packed eigenvector matrix
  // matz = make eigenvectors if matz not equal zero
  //      = only calculate eigenvalues if matz is zero
  // ierr = error numbers
  // create a rg object
  rg rg(AV, wr, wi, matz, z, ierr);

  cout << "ierr: " << ierr <<  Ch(wr,wi) << z;

  // unpack the eigenvectors
  Matrix Pr, Pinvr, Pi, Pinvi;
  rg.Unpack( wr, wi, z, Pr, Pi, Pinvr, Pinvi);
  cout << Pr << Pi << Pinvr << Pinvi;

  // test the inversion
  Matrix e,f;
  Mult2mats(Pr, Pi, Pinvr, Pinvi, e, f);
  cout << e << f;

  return 0;
}



