// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.

///////////////////////// eigenvalues and eigenvectors of a real
///////////////////////// general matrix.

#include "matv.h"

#ifndef _RG_
#define _RG_

////////// doesnt work with complex matrices
#ifndef USE_COMPLEX
class rg
{
  public:
  rg(Matrix &AV, Matrix &wr, Matrix &wi, int matz, Matrix &z, int &ierr);
  void Unpack(Matrix &wr, Matrix &wi, Matrix &z, Matrix &Pr, Matrix &Pi,
              Matrix &Pinvr, Matrix &Pinvi);
  private:
	 FLOAT d_sign( FLOAT a, FLOAT b);
	 int cdiv_(FLOAT ar, FLOAT ai, FLOAT br, FLOAT bi, FLOAT &cr, FLOAT &ci);
   void cmult_(FLOAT a, FLOAT b, FLOAT c, FLOAT d, FLOAT &e, FLOAT &f);
	 int balanc_(int &n, Matrix &a, int *low, int *igh, Matrix &scale);
	 int balbak_(int &n, int *low, int *igh, Matrix &scale, int &m, Matrix &z);
	 int elmhes_(int &n, int *low, int *igh, Matrix &a, int *int_);
	 int eltran_(int &n, int *low, int *igh, Matrix &a, int *int_, Matrix &z);
	 int hqr_(int &n, int *low, int *igh, Matrix &h, Matrix &wr, Matrix &wi, int &ierr);
	 int hqr2_(int n, int *low, int *igh, Matrix &h, Matrix &wr, Matrix &wi,
			 Matrix &z, int &ierr);
    void Sweep2mats(int k1, int k2, Matrix& a, Matrix &b);
    void Inv2mats(Matrix &a, Matrix &b, Matrix &ai, Matrix &bi);


};
#endif
#endif
