// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.

#include <matv.h>
#include <strtype.h>

//////////////////////////////////////////////////////////////
//////////////////////////// XYplot objects ////////////////
//////////////////////////////////////////////////////////////


#ifndef _MATVGRAF
#define _MATVGRAF

#if !(__BCPLUSPLUS__ || __TCPLUSPLUS__)
#error GMatrix class requires Borland BGI functions
#endif

#ifdef USE_COMPLEX
#error GMatrix Class does not work for complex matrices
#endif

#ifdef __TINY__
#error GMatrix class will not work in the tiny model.
#endif

#include <conio.h>
#include <stdarg.h>
#include <graphics.h>

// the Axis class is called from the GMatrix Class. It
// is not needed otherwise, and will not be commented
class Axis
{
   protected:
     // uses fortran translations of Algorithm AS 168 of Applied Statistics
      double valmin, step;
      double *vals, fmn, fmx, offset;
      int nvals, irprin, maxpr, ifact;
      Matrix *Vals;
      int nplt, mpv, ir, ifault , iv;
      double dmax( double x, double y);
      void scale(double fmn, double fmx, int nplt, int mpv,
               double &valmin, double &step, int &nvals,int &ir, int &ifault);
      void axis(double valmin,double step,int nvals, int maxpr,int ir,
	           int &irprin, double &offset, int &ifact, double vals[], int iv,
	           int &ifault);
      void getvals(double fmn,double fmx,int n, double vals[],
	               double &offset,int &ifact,int &nvals,int &irprin);
    struct linesettingstype lineinfo;

   public:
      Axis( Matrix &grf_vec, int col, int pixels, int pxlspplot);
      ~Axis( void );

      virtual void Show( bboolean gridon )
        {
          restorecrtmode();
          Matrix::Nrerror("AXIS: trying to show an undefined axis object");
        }
      strtype GetAxisLabel( strtype &name );
      double Rescale( double x );

};
class YAxis:public Axis
{
   private:
     double deltay;
     int h, w, xlen, ylen, bmarg, umarg, lmarg, rmarg;

   public:
     double miny, maxy;

     virtual void Show( bboolean gridon );
     YAxis( Matrix &grf, int xxlen,  int yylen,  int ww, int hh,
            int bbmarg,   int uumarg, int llmarg, int rrmarg);
};

class XAxis:public Axis
{
   private:
     double deltax;
     int w, h, xlen, ylen, bmarg, umarg, lmarg, rmarg;

   public:
     double minx, maxx;

     virtual void Show( bboolean gridon );
     XAxis( Matrix &grf, int xxlen,  int yylen, int ww, int hh,
            int bbmarg,   int uumarg, int llmarg, int rrmarg);
};


///////////////////////////////  graph matrix class

class GMatrix
{
  private:
    // Borland graphics information. bgi files must be available
    int    GraphDriver;
    int    GraphMode;
    int    MaxX, MaxY;
    int    MaxColors;
    int    ErrorCode;
    struct linesettingstype lineinfo;
    struct viewporttype viewinfo;


    // reference lines. can have at most 20 reference lines
    double *hrefs;
    double *vrefs;
    int nvrefs, nhrefs;

    // output a line, and pause function ESC stops program
    int  gprintf(int *xloc, int *yloc, char *fmt, ... );
    void Pause();

    // graph is stored in a Matrix: [graphid, symbol, x, y] 4 cols
    int    graphnum;        // number of graphs in grf;
    Matrix *grf;

    // plot a point on the screen
    void plotpoint( int ix, int iy, int symbol);

  public:

    // constructors and destructors

    GMatrix( void );
    GMatrix( Matrix &ROp, int symbol= -' '); // ROp should be rx2 matrix
                                              // column 1 is x, col 2 is y
    ~GMatrix( void );

    // display a graph
    void Show( void );

    // add a new vector to plot
    void AddVec( Matrix &ROp, int symbol = -' ');

    // annotation options

    strtype *title, *title2, *xname, *yname, *PathToDriver;
    bboolean RectangleOn, YGridOn, XGridOn;
    void Href( double href );
    void Vref( double vref );
    int ClearHref( void ){ int t=nhrefs; nhrefs = -1; return t;}
    int ClearVref( void ){ int t=nvrefs; nvrefs = -1; return t;}

    // save the grf matrix
    void SaveGraph( char *fid ) { Writea( fid, *grf ); }
};

#endif
