/* a little freebe for those of you who yearn for simpler days */
/* a Texas Pick Six Lotto Program in ANSI C without floating point*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


void shuffle(int n, int x[])
{
  /* generate a random index to swap with */
  int i, j, t;
  for (i = 0; i < n; i++) {
    j = rand() % n;
    t = x[i];
    x[i] = x[j];
    x[j] = t;
    if (!(i % 2)) printf("%3d\r", j);
  }
  printf("   \r");
}

int sort_function(const void *a, const void *b)
{
  return (*((int *) a) < *((int *) b)) ? - 1 : 1;
}

main()
{
  int i, j, x[6][50], n = 50;
  time_t t;
  unsigned basetime;
  /* seed the random number generator with the clock, after a wait */
  
  basetime = (unsigned) time(&t);
  while (basetime == (unsigned) time(&t));
  srand((unsigned) time(&t));
  for (i = 0; i < 6; i++)
    for (j = 0; j < 50; j++) x[i][j] = j;
  
  printf("\nRoll the magic 50 sided die\n");
  for (i = 0; i < 6; i++) shuffle(n, x[i]);
  
  for (i = 0; i < 6; i++)
    qsort((void *) (x[i]), 6, sizeof (int), sort_function);
  
  printf("\nYour Lucky Lotto Pick 6 Draws are \n\n");
  for (i = 0; i < 6; i++) {
    printf("%d:", i + 1);
    for (j = 0; j < 6; j++) printf("%3d", x[i][j] + 1);
    printf("\n");
  }
  return 0;
}
