
// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.


////////////////// distribution functions tester
////////////////// this is a simple probability calculator

#include "dist.h"

/********************************* end noncentral chi-square */
void list_choice(void)
{
  
  cout << "0. ) quit" << endl;
  cout << "1. ) beta( x, a, b)" << endl;
  cout << "2. ) non-central beta(x,a,b,l)" << endl;
  cout << "3. ) non-central f(f,df1,df2,l)" << endl;
  cout << "4. ) central f(f,df1,df2)" << endl;
  cout << "5. ) inverse standard normal(p)" << endl;
  cout << "6. ) standard normal(z)" << endl;
  cout << "7. ) inverse non-central f(p,df1,df2,l)" << endl;
  cout << "8. ) inverse central f(p,df1,df2)" << endl;
  cout << "9. ) non-central t(t,df,l)" << endl;
  cout << "10.) central t(t,df)" << endl;
  cout << "11.) inverse non-central t(p,df,l)" << endl;
  cout << "12.) inverse central t(p,df)" << endl;
  cout << "13.) gamma(x,a,b)" << endl;
  cout << "14.) non-central chi-square(x,df,l)" << endl;
  cout << "15.) central chi-square(x,df)" << endl;
  cout << "16.) inverse non-central chi-square(p,df,l)" << endl;
  cout << "17.) inverse central chi-square(p,df)" << endl;
}
void evaluate_probs(int choice)
{
  double x, a, b, p, df1, df2, df, lam, f, t;
  x = a = b = p = df1 = df2 = df = lam = f = t = 0.0;
  
  switch (choice) {
    case 0 : { exit(0);
      break;
    }
    case 1 : { 
      cout << "x  : " << endl;
      cin >> x;
      cout << "a  : " << endl;
      cin >> a;
      cout << "b  : " << endl;
      cin >> b;
      cout << "beta dist " << endl;
      cout <<"p  :" << betai(a, b, x) << endl;
      break;
    }
    case 2 : { 
      cout << "x  : " << endl;
      cin >> x;
      cout << "a  : " << endl;
      cin >> a;
      cout << "b  : " << endl;
      cin >> b;
      cout << "l  : " << endl;
      cin >> lam;
      cout << "non-central beta dist " << endl;
      cout << "p : " << ncbeta(x, a, b, lam) << endl;
      break;
    }
    case 3 : { cout << "f  : " << endl;
      cin >> f;
      cout << "df1: " << endl;
      cin >> df1;
      cout << "df2: " << endl;
      cin >> df2;
      cout << "l  : " << endl;
      cin >> lam;
      cout << "non-central f " << endl;
      cout << "p : " << ncf(f, df1, df2, lam) << endl;
      break;
    }
    case 4 : { cout << "f  : " << endl;
      cin >> f;
      cout << "df1: " << endl;
      cin >> df1;
      cout << "df2: " << endl;
      cin >> df2;
      cout << "central f " << endl;
      cout << "p  : " << probf(f, df1, df2);
      break;
    }
    case 5 : { cout << "p  : " << endl;
      cin >> p;
      cout << "inverse normal " << endl;
      
      cout << "x  : " << "" << probnormi(p) << endl;
      
      break;
    }
    case 6 : { cout << "x  : " << endl;
      cin >> x;
      cout << "standard normal " << endl;
      
      cout << "p  : " << setw(5) << setprecision(4) << "" << probnorm(x) << 
        endl
        ;
        
      
      break;
    }
    case 7 : { cout << "p  : " << endl;
      cin >> p;
      cout << "df1: " << endl;
      cin >> df1;
      cout << "df2: " << endl;
      cin >> df2;
      cout << "l  : " << endl;
      cin >> lam;
      cout << "inverse non-central f " << endl;
      cout << "f  : " << ncfinv(p, df1, df2, lam);
      break;
    }
    case 8 : { cout << "p  : " << endl;
      cin >> p;
      cout << "df1: " << endl;
      cin >> df1;
      cout << "df2: " << endl;
      cin >> df2;
      cout << "inverse central f " << endl;
      cout << "f  : " << probfi(p, df1, df2);
      break;
    }
    case 9 : { cout << "t  : " << endl;
      cin >> t;
      cout << "df1: " << endl;
      cin >> df;
      cout << "lam: " << endl;
      cin >> lam;
      cout << "non-central t " << endl;
      cout << "p  : " << nct(t, df, lam);
      
      break;
    }
    case 10 : { cout << "t  : " << endl;
      cin >> t;
      cout << "df1: " << endl;
      cin >> df;
      cout << "central t " << endl;
      cout << "p  : " << probt(t, df);
      
      break;
    }
    case 11 : { cout << "p  : " << endl;
      cin >> p;
      cout << "df : " << endl;
      cin >> df;
      cout << "lam: " << endl;
      cin >> lam;
      cout << "inverse non-central t " << endl;
      cout << "t  : " << ncti(p, df, lam);
      
      break;
    }
    case 12 : { cout << "p  : " << endl;
      cin >> p;
      cout << "df1: " << endl;
      cin >> df;
      cout << "inverse central t " << endl;
      cout << "t  : " << probti(p, df);
      break;
    }
    case 13 : { cout << "x  : " << endl;
      cin >> x;
      cout << "a  : " << endl;
      cin >> a;
      cout << "b  : " << endl;
      cin >> b;
      cout << "gamma dist " << endl;
      cout << "p  : " << gammp(x, a, b);
      break;
    }
    case 14 : { cout << "x  : " << endl;
      cin >> x;
      cout << "df : " << endl;
      cin >> df;
      cout << "lam: " << endl;
      cin >> lam;
      cout << "non-central chi-square " << endl;
      cout <<"p  : ", ncchi(x, df, lam);
      break;
    }
    case 15 : { cout << "x  : " << endl;
      cin >> x;
      cout << "df : " << endl;
      cin >> df;
      cout << "central chi-square " << endl;
      cout << "p  : " << probchi(x, df);
      break;
    }
    case 16 : { cout << "p  : " << endl;
      cin >> p;
      cout << "df : " << endl;
      cin >> df;
      cout << "lam: " << endl;
      cin >> lam;
      cout << "inverse non-central chi-square " << endl;
      cout << "x  : " << ncchii(p, df, lam);
      break;
    }
    case 17 : { cout << "p  : " << endl;
      cin >> p;
      cout << "df : " << endl;
      cin >> df;
      cout << "inverse central chi-square " << endl;
      cout << "x  : " << probchii(p, df);
      break;
    }
    default : cout << " try again " << endl;
    
  } 	/* end switch */
}
main()
{
  int choice = 1, another = 1;
  while (choice) {
    list_choice();
    cout << "enter your choice:  " << endl;
    cin >> choice;
    another = 1;
    while (another && choice) {
      cout << "enter the parameters" << endl;
      evaluate_probs(choice);
      cout << "another ( 0=no, 1=yes ): " << endl;
      cin >> another;
    }
  }
  exit(0);
}

