// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.

///////
#include "urandvec.h"
void testmult(void)
{  // generate random numbers from a general discrete distribution
   // this uses the probability integral transform in its simplest 
   // form. This gives multinomial distribution.

   // pd is the density, Pd is the distribution function
   double pd[4]={0.1, 0.3, 0.3, 0.3};
   Matrix Pd(4,1,pd);
   Pd=Cusum(Pd);
   Pd(Pd.r) = 1.00;
   cout << Pd;

   // M is the random vector.
   Matrix M(Pd.r,1,0.0);
   static URandVec u;

   for (int i=0; i<=20; i++){
     double p = u();
     for( int j=1; j<M.r; j++){
        cout << j << " " << p << " " << Pd(j) << endl;
        if( p < Pd(j) ) break;
     }
     M(j) += 1;
     cout << "final j: " << j << endl;
   }
   // a multinomial random variable.
   cout << M;

}

main()
{
  testmult();

  int i;

  NormalRV n,nn(1,2);
  cout << n;
  cout << nn;
  for(i=1; i<=10; i++)  cout << n() << endl;

  // note n(1234) returns a number but ReSeed(1234) does not.
  cout << "Test Reseed " << endl;
  n.ReSeed(1234);
  for( i=1; i<=10; i++)  cout << n() << endl;
  cout << "Should Be the Same " << endl;
  cout << n(1234) << endl;
  for( i=1; i<10; i++)  cout << n() << endl;

  NCGammaRV g, gg(3,4), ggg(3,4,4);
  cout << g << gg << ggg;
  for( i = 1; i<=10; i++) cout << g() << " " << gg() << " " << ggg() << endl;

  NCChiRV chi, chi1(3), chi2(3,4);
  cout << chi << chi1 << chi2;
  for( i = 1; i<=10; i++) cout << chi() << " " << chi1() << " " << chi2() << endl;

  NCFRV F, F1(3,3), F2(3,3,4);
  cout << F << F1 << F2;
  for( i = 1; i<=10; i++) cout << F() << " " << F1() << " " << F2() << endl;

  NCBetaRV Beta, Beta1(1,2), Beta2(1,2,4);
  cout << Beta << Beta1 << Beta2;
  for( i = 1; i<=10; i++) cout << Beta() << " " << Beta1() << " " << Beta2() << endl;

  NCtRV t, t1(3), t2(3,4);
  cout << t << t1 << t2;
  for( i = 1; i<=10; i++) cout << t() << " " << t1() << " " << t2() << endl;

  ExpRV e, ee(3);
  cout << e << ee;
  for( i = 1; i<=10; i++) cout << e() << " " << ee() << endl;

  MvnRV Z(Fill(10,1,4), Ident(10)+Fill(10,10,.3));
  cout << Z;
  for( i=1; i<=10; i++) { cout << i << ":" << Tran(Z()); }

  return 0;
}
