// Version: 2.1
// Author: Mark Von Tress, Ph.D.
// Date: 01/07/96

// Copyright(c) Mark Von Tress 1996


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.


#include "strtype.h"

strtype::strtype(strtype &str)  // copy constructor
{ int len = MAXCHARS;
        len = strlen(str.name);
        len = (len >= MAXCHARS) ? MAXCHARS - 2 : len;
        strncpy(name, str.name, len);
        name[len] = '\0';
}
strtype::strtype(char *str)
{ int len = MAXCHARS;
        len = strlen(str);
        len = (len >= MAXCHARS) ? MAXCHARS - 2 : len;
        strncpy(name, str, len);
        name[len] = '\0';
}
strtype::strtype(void)
{
        name[0] = '\0';
}

strtype strtype::operator + (strtype &str)
{

        int len1, len2;
        len1 = strlen(name);
        len2 = strlen(str.name);
        int len =(len2 + len1 >= MAXCHARS) ? MAXCHARS - len1 - 3 : len2;
        len = (len < 0 || len >= MAXCHARS - 1) ? 0 : len;
        strncat(name, str.name, len);
        name[len + len1] = '\0';
        return *this;
}
strtype strtype::operator + (const char *str)
{
        int len1 = strlen(name);
        int len2 = strlen(str);
        int len = (len2 + len1 >= MAXCHARS) ? MAXCHARS - len1 - 3 : len2;
        len = (len < 0 || len >= MAXCHARS - 1) ? 0 : len;
        len = (len >= MAXCHARS) ? 0 : len;
        strncat(name, str, len);
        name[len + len1] = '\0';
        return *this;
}
strtype strtype::operator = (strtype &str)
{
        if( this == &str ) return *this;
        int len = (strlen(str.name) >= MAXCHARS) ? MAXCHARS - 3
                        : strlen(str.name);
        strncpy(name, str.name, len);
        name[len] = '\0';
        return *this;
}
strtype strtype::operator = (const char *str)
{
        int len = (strlen(str) >= MAXCHARS) ? MAXCHARS - 2 : strlen(str);
        strncpy(name, str, len);
        name[len] = '\0';
        return *this;
}

ostream &operator<<(ostream &s, strtype &S)
{
     s << S.name;
     return s;
}          
