# This file is an Msub script

# It takes a text file and joins together lines that (seem to) belong to
# the same paragraph. 

# This is useful if you want to print a text, e.g. some readme-file for
# a shareware program, which is formatted for a different (esp. wider!)
# line length than you want to print it with.  Like printing 80-coloumn
# text in 68 columns using the shareware utility 2col.
# After joining paragraphs you need to re-break them, e.g. by importing
# the text into a wordprocessor.

!screen

# For any line with at least 50 chars, if the next line is not blank and 
# does not begin with whitespace, then join the two.

# :b == whitespace other than $^
!:b=[\ \9]

# :o == ordinary character; non-whitespace
!:o=[^:b$^]

# First, let's get rid of hyphenating '-'s at newline, along with the newline.
:l/'-':b*$^/
""

!newpass

# A single space is made to replace any trailing whitespace in the first
# line and cr/lf.  Plus there's a little magic in the second line to lose
# trailing ws.

# Adjust the number of dots here to cater for different input line length.

...........................................................		\
.*:o/:b*$^/:o
" "
