# This file is an Msub script

#
# A scripts such as DETAB.MS can be horribly slow when working on large
# files that exceed physical memory.  This is because of the !iterate
# command, that requires Msub to go over the same file several times,
# causing major swapping to occur.
#
# Here's a way to fix that: By taking on one line at a time, and doing the
# iterating over just that one line, locality is much improved.
#
# Also, this makes the script a one-pass script, and a one-pass script
# with !binary uses only half as much memory.  !binary has the unfortunate
# effect that this script cannot change the first line (because it doesn't
# begin with ^), but that may be worth it.
#

!binary
!sub detab
	!include detab
!end

^.*$
\detab(`)
