{C+,U+,R+}
(*****************************************************************************

    Program PR

*****************************************************************************)

program pr;

Const

    str_enhanced     = ^['[2"z' ;
    str_wide         = ^['[4w'  ;
    str_normal_print = ^['[0"z' ;
    str_normal_width = ^['[0w'  ;

type

    name            = string[40] ;
    line            = string[255];
    CommandString   = string[127];
    str11           = string[11];


    switches        = record
                        lines_page       : integer    ;
                        indent_spaces    : integer    ;
                        header           : boolean    ;
                        wide             : boolean    ;
                        copies           : integer    ;
                        line_spaces      : integer    ;
                        enhanced         : boolean    ;
                        first_page       : integer    ;
                        last_page        : integer    ;
                        spool            : boolean    ;
                        disk             : char       ;
                      end;

    opened_fcb      = record
                        drive_number      : byte ;
                        file_name         : array[1..8] of char ;
                        extension         : array[1..3] of char ;
                        current_block     : integer ;
                        record_size       : integer ;
                        file_size         : array[1..2] of integer ;
                        date_last_write   : array[1..2] of byte ;
                        time_last_write   : array[1..2] of byte ;
                        reserved          : array[1..8] of byte ;
                        current_record    : byte ;
                        relative_record   : array[1..2] of integer ;
                      end;

    registers       = record
                        AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : integer
                      end;

    disk_opt_type   = set of 'A'..'E' ;

var

    i,j,k,l          : integer ;
    str2             : string[2] ;
    lf               : boolean ;

    Buffer           : CommandString ;
    CL               : CommandString absolute cseg:$80 ;

    file_in          : text ;
    file_out         : text ;
    file_out_1       : record
                         arr_11 : array[1..11] of byte ;
                         fcb    : opened_fcb ;
                       end absolute file_out ;

    file_name        : name ;
    new_line         : line ;
    line_in          : line ;
    line_out         : line ;
    line_number      : integer ;
    page_number      : integer ;
    copies_printed   : integer ;
    print_page       : boolean ;
    right_margin     : integer ;
    left_margin      : integer ;

    def_switches     : switches ;
    file_switches    : switches ;

    regpack          : registers ;

    disk_options     : disk_opt_type ;

    hh,mm,ss,dd      : integer ;
    mo,day,year,dow  : integer ;

{---------------------------------------------------------------------------}
Procedure GetTime ( var hh : integer ;
                    var mm : integer ;
                    var ss : integer ;
                    var dd : integer );

  begin

    regpack.ax := $2c00 ;
    MsDos(regpack) ;
    with regpack do
    begin
        hh := cx shr 8 ;
        mm := cx mod 256 ;
        ss := dx shr 8 ;
        dd := dx mod 256 ;
    end;

  end; {GetTime}

{---------------------------------------------------------------------------}
Procedure GetDate ( var mo    : integer ;
                    var dow   : integer ;
                    var day   : integer ;
                    var year  : integer );

  begin

    regpack.ax := $2A00 ;
    MsDos(regpack);
    with regpack do
        begin
            year := cx ;
            day  := dx mod 256 ;
            mo   := dx shr 8 ;
            dow  := ax mod 256 ;
        end;

  end; {GetDate}

{---------------------------------------------------------------------------}
Function CurrentDrive : char ;

  begin

    regpack.ax := $1900 ;
    MsDos(regpack) ;
    CurrentDrive := Chr(integer('A') + regpack.ax mod 256) ;

  end; {CurrentDrive}

{---------------------------------------------------------------------------}
Procedure GetCmdLine ;

  begin

    buffer := CL;
    For i := 1 to length(buffer) do buffer[i] := UpCase(buffer[i]) ;

  end; {GetCmdLine}

{---------------------------------------------------------------------------}
Procedure TrimLeading ;

  begin

    while (buffer[1] = ' ') or (buffer[1] = ',') do delete(buffer,1,1) ;

  end; {TrimLeading}

{---------------------------------------------------------------------------}
Function Pos_Delimiter : integer  ;

  var
    ch : char ;

  begin

    i := 1 ;
    j := length(buffer) ;
    while (i<=j) and not(buffer[i] in ['/',',',' ']) do i:=i+1 ;
    pos_delimiter := i ;

  end; {Pos_Delimiter}

{---------------------------------------------------------------------------}
Function GetFileName : Boolean ;

  Var

    len : integer ;
    pos : integer ;

  begin

    TrimLeading ;
    len := length(buffer);
    pos := Pos_delimiter ;

    if len > 0 then
    begin
      file_name := copy(buffer,1,pos-1) ;
      delete(buffer,1,pos-1);
      GetFileName := true ;
    end
    else
    begin
      file_name := '' ;
      GetFileName := false ;
    end;

  end; {GetFileName}

{---------------------------------------------------------------------------}
Procedure Get_Switches ( var sw : switches) ;

  Function Switch_Value : integer ; { -1 indicates invalid result }

    begin

      k := pos('=',buffer) ;
      if (k > 0) and (k < i) then
        begin
          val(copy(buffer,k+1,i-k-1),j,l) ;
          if l=0 then switch_value := j
          else
          begin
            writeln('    ERROR - invalid switch  /',copy(buffer,1,i));
            switch_value := -1 ;
          end;
        end
      else switch_value := -1 ;

    end; { Switch_Value }

  begin { Get_Switches }

    TrimLeading ;
    While buffer[1] = '/' do
    begin
      delete(buffer,1,1);
      i := Pos_Delimiter ;
      j := Switch_Value ;

      if j>=0 then
      begin
       case upcase(buffer[1]) of
        'P' : sw.lines_page    := j     ;
        'I' : sw.indent_spaces := j     ;
        'C' : sw.copies        := j     ;
        'S' : sw.line_spaces   := j     ;
        'F' : sw.first_page    := j     ;
        'L' : sw.last_page     := j     ;
       end;
      end;

      case upcase(buffer[1]) of
        'H' : sw.header        := true  ;
        'W' : sw.wide          := true  ;
        'E' : sw.enhanced      := true  ;
        'D' : begin
                sw.spool       := true  ;
                if upcase(buffer[2]) in disk_options then
                     sw.disk := buffer[2]
                else sw.disk := CurrentDrive ;
              end;
        'N' : begin
                case upcase(buffer[2]) of
                  'H' : sw.header    := false ;
                  'W' : sw.wide      := false ;
                  'E' : sw.enhanced  := false ;
                end;
              end;
      end;

      if i>1 then delete(buffer,1,i-1) else buffer := '' ;
      TrimLeading ;

    end;

    if sw.wide then right_margin := 132
    else right_margin := 80 ;
    left_margin := 1 + sw.indent_spaces ;

  end; { Get_Switches }

{---------------------------------------------------------------------------}
Procedure Init_Default_Switches ;

  begin

    with def_switches do
    begin
      lines_page    := 60           ;
      indent_spaces := 0            ;
      header        := true         ;
      wide          := false        ;
      copies        := 1            ;
      line_spaces   := 1            ;
      enhanced      := false        ;
      first_page    := 1            ;
      last_page     := 9999         ;
      spool         := false        ;
      disk          := CurrentDrive ;
    end;

  end; {Init_Default_Switches}

{---------------------------------------------------------------------------}
Procedure New_Page ;

  begin

    page_number:=page_number+1;
    write(page_number,' ');

    if (page_number>=file_switches.first_page)
    and (page_number<=file_switches.last_page) then
      print_page := true  else print_page := false ;

    if page_number>file_switches.first_page then
        if print_page then write(file_out,^L);
    if file_switches.header then
    begin
      if print_page then
      begin
        write  (file_out,file_name);
        write  (file_out,mo:32-length(file_name));
        write  (file_out,'/',day:2,'/',year:4);
        write  (file_out,hh:6,':',mm:2);
        write  (file_out,'PAGE':23);
        writeln(file_out,page_number:4);
        writeln(file_out);
        writeln(file_out);
      end;
      line_number:=4
    end
    else line_number:=1;

  end; {New_Page}

{---------------------------------------------------------------------------}
Function Get_Line : boolean ;

  begin

    line_in := '';
    if eof(file_in) then Get_line := false
    else
    begin
      if length(new_line) <= 0 then readln(file_in,new_line) ;
      i := pos(^L,new_line);
      while i = 1 do
      begin
        new_page ;
        delete(new_line,1,1);
        i := pos(^L,new_line);
      end;

      if i = 0 then
      begin
        line_in := new_line ;
        new_line := '';
      end
      else
      begin
        line_in := copy(new_line,1,i-1) ;
        delete(new_line,1,i);
      end ;

      Get_Line := true ;

    end;

  end; {Get_Line}

{---------------------------------------------------------------------------}
Procedure Indent_Line_In ;

  begin

    for i := 1 to left_margin-1  do insert(' ',line_in,1) ;

  end; {Indent_Line_in}

{---------------------------------------------------------------------------}
Procedure Trim_line_In ;

  begin

      if length(line_in) > right_margin then
      begin
        delete(line_in, right_margin+1, length(line_in)-right_margin);
        line_in[right_margin] := '*' ;
      end;

  end; {Trim_Line_In}

{---------------------------------------------------------------------------}
Function Make_File_Name : Str11 ;

  Var

    Strg : string[9] ;

  begin

    strg := 's' ;
    GetTime(hh,mm,ss,dd);
    str(mm,str2);
    strg := strg + str2 ;
    str(ss,str2);
    strg := strg + str2 + '.spl' ;
    Make_File_Name := def_switches.disk + ':' + strg ;

  end; {Make_File_Name}

{---------------------------------------------------------------------------}
begin { Main program }

    lf := false;
    GetCmdLine ;
    Init_Default_Switches ;
    Get_Switches (def_switches) ;

    if def_switches.spool then assign(file_out,make_file_name)
    else assign(file_out,'LST:');
    {$I-} rewrite(file_out) {$I+};
    if ioresult <> 0 then writeln('   ERROR - unable to open output file')
    else
    begin
      repeat
      begin
        file_switches := def_switches ;
        if GetFilename then
        begin
            Get_Switches (file_switches) ;
            if file_switches.enhanced then write(file_out,str_enhanced);
            if file_switches.wide     then write(file_out,str_wide    );
            assign(file_in,file_name);
            {$I-} reset(file_in) {$I+} ;
            if ioresult<>0 then writeln('   ERROR - file not found')
            else
            begin
              write (file_name:20,'  printing page ');
              GetTime (hh,mm,ss,dd) ;
              GetDate (mo,dow,day,year) ;
              copies_printed := 0;
              new_line := '';
              repeat
                line_number := file_switches.lines_page;
                page_number := 0;
                if lf then write(file_out,^L) else lf:=true ;
                while Get_Line do
                begin
                  if line_number>=file_switches.lines_page then New_page;
                  if print_page then
                  begin
                    indent_line_in;
                    trim_line_in;
                    write(file_out,line_in);
                    for i:=1 to file_switches.line_spaces do
                    begin
                      writeln(file_out);
                      line_number:=line_number+1;
                    end;
                  end;
                end;
                reset(file_in);
                copies_printed := copies_printed + 1 ;
              until copies_printed >= file_switches.copies ;
              close(file_in);
              writeln;
            end
        end;
        write(file_out,str_normal_print,str_normal_width);
      end;
      until length(file_name)<=0 ;

      if def_switches.spool then
      begin
        close(file_out);
        reset(file_out);
        with regpack do
        begin
          ax := $0001 ;
          dx := ofs(file_out_1.fcb) ;
          ds := seg(file_out_1.fcb) ;
        end;
        intr($2F,regpack);
      end
      else write(file_out,^L);

    end;
end.
