// oprnstream -- adaptation of ostream for printer output
/***************************************************************************
	oprnstream is modified to allow the interception of special printer
	characters for PostScript printing.  I could think of no better way
	to do this.  Each string in PostScript printing is encapsulated in
	parentheses and tabbing and linefeeds must be handled by the driver.
	That means this module supplants the role of a PostScript Driver for
	Dos programs.  It is also useful for HP Laserjet and Epson printers.

	The major modifications are the addition of putbuf() which replaces
	sputc() and putn() which replaces sputn() in ostream.  putbuf places
	characters in the buffer one at a time and scans for PostScript code.
	putn places strings in the buffer by calling putbuf.

	All of the normal manipulators are duplicated for use here also.

	One modification of IOMANIP.H in your Include directory is required.
	You must declare a friend function for SMANIP template. Add the following
	to the definition of SMANIP<typ> in IOMANIP.H

			friend oprnstream _FAR & _Cdecl operator<<(oprnstream _FAR & _s, const SMANIP(typ) _FAR & _f) {       \
						(*_f._fn)(_s, _f._ag); return _s; }             \


***************************************************************************/

#ifndef __cplusplus
#error Must use C++ for the type iostream.
#endif

#ifndef __OPRNSTR_H
#define __OPRNSTR_H

#if !defined(__IOSTREAM_H)
#include <iostream.h>
#endif

#if !defined(___DEFS_H)
#include <_defs.h>
#endif

#if !defined(__MEM_H)
#include <mem.h>    // to get memcpy and NULL
#endif

#pragma option -Vo-
#if defined(__BCOPT__) && !defined(_RTL_ALLOW_po)
#pragma option -po-
#endif

// Definition of EOF must match the one in <stdio.h>
#define EOF (-1)

#define True 1
#define False 0

// extract a char from int i, ensuring that zapeof(EOF) != EOF
#define zapeof(i) ((unsigned char)(i))

_CLASSDEF(oprnstream)
_CLASSDEF(oprnstream_withassign)


#define POINTS_PER_INCH 72         // define units per inch for PostScript


class _CLASSTYPE oprnstream : virtual public ios {
private:
	// flags for handling PostScript Printing
	int psflag;  // True or 1 if PostScript, False or 0 if not
	int newpage;
	int header;

	void    _Cdecl outstr(const signed char _FAR *, const signed char _FAR *);

protected:
// variables to define printer type
	int typesize;
	float PageSizeX;
	float PageSizeY;
	float TM, RM, LM, BM;    // margins for paper (set to 0.25 ")
	int putbuf(int c);
	int putn(const char *c, int len);

	// part of original ostream
	int     _Cdecl do_opfx();   // implementation of opfx
	void    _Cdecl do_osfx();   // implementation of osfx

	// needed to set PSFlag
			_Cdecl oprnstream(int flag);


public:
	// constructors and destructor
		_Cdecl oprnstream(streambuf _FAR *, int flag);
virtual _Cdecl ~oprnstream();

	int _Cdecl opfx();      // output prefix function
	void _Cdecl osfx();     // output suffix function

	void setPSFlag(int flag) { psflag = flag; }  // set PostScript flag
	void setHdrFlag(int flag) { header = flag; } // used to send the PostScript
												 // header to the printer
	int PSFlag(void) { return psflag; }       // determine setting of flag
	int PageFlag(void) {return newpage; }
	int HdrFlag(void) { return header; }

	oprnstream _FAR & _Cdecl flush();

	// set/read the put pointer's position
	oprnstream _FAR & _Cdecl seekp(streampos);
	oprnstream _FAR & _Cdecl seekp(streamoff, ios::seek_dir);
	streampos _Cdecl tellp();

	/*
	 * Unformatted insertion operations
	 */
	oprnstream _FAR & _Cdecl put(char);  // insert the character
	oprnstream _FAR & _Cdecl write(const   signed char _FAR *, int); // insert the string
	oprnstream _FAR & _Cdecl write(const unsigned char _FAR *, int); // insert the string

	/*
	 * Formatted insertion operations
	 */
	// insert the character
	oprnstream _FAR & _Cdecl operator<< (  signed char);
	oprnstream _FAR & _Cdecl operator<< (unsigned char);

	// for the following, insert character representation of numeric value
	oprnstream _FAR & _Cdecl operator<< (short);
	oprnstream _FAR & _Cdecl operator<< (unsigned short);
	oprnstream _FAR & _Cdecl operator<< (int);
	oprnstream _FAR & _Cdecl operator<< (unsigned int);
	oprnstream _FAR & _Cdecl operator<< (long);
	oprnstream _FAR & _Cdecl operator<< (unsigned long);
	oprnstream _FAR & _Cdecl operator<< (float);
	oprnstream _FAR & _Cdecl operator<< (double);
	oprnstream _FAR & _Cdecl operator<< (long double);

	// insert the null-terminated string
	oprnstream _FAR & _Cdecl operator<< (const   signed char _FAR *);
	oprnstream _FAR & _Cdecl operator<< (const unsigned char _FAR *);

	// insert character representation of the value of the pointer
	oprnstream _FAR & _Cdecl operator<< (void _FAR *);

	// extract from streambuf, insert into this oprnstream
	oprnstream _FAR & _Cdecl operator<< (streambuf _FAR *);

	// manipulators
	oprnstream _FAR & _Cdecl operator<< (oprnstream _FAR & (_Cdecl *_f)(oprnstream _FAR &));
	oprnstream _FAR & _Cdecl operator<< (ios _FAR & (_Cdecl *_f)(ios _FAR &));

};



// inline functions


inline int  _Cdecl oprnstream::opfx() { return ospecial ? do_opfx() : 1; }
inline void _Cdecl oprnstream::osfx() { if( x_flags & (stdio | unitbuf) ) do_osfx(); }
#ifdef _BIG_INLINE_
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (signed char _c) {
				if( opfx() )
					if( putbuf(_c) == EOF ) setstate(badbit);
						osfx();
				return *this;
				}
#endif
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (unsigned char _c) {
				return *this << (signed char)_c;
				}
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (const signed char _FAR * _s) {
				outstr(_s, (const signed char _FAR *)0);
				return *this;
				}
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (const unsigned char _FAR * _s) {
				outstr((const signed char _FAR *)_s, (const signed char _FAR *)0);
				return *this;
				}
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (short _i)
				{ return *this << (long) _i; }
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (unsigned short _i)
				{ return *this << (unsigned long) _i; }
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (int _i)
				{ return *this << (long) _i; }
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (unsigned int _i)
				{ return *this << (unsigned long) _i; }
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (float _f)
				{ return *this << (long double) _f; }
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (double _d)
				{ return *this << (long double) _d; }
inline oprnstream _FAR & _Cdecl oprnstream::operator<< (oprnstream _FAR & (_Cdecl *_f)(oprnstream _FAR &))
				{ return (*_f)(*this); }
inline oprnstream _FAR & _Cdecl oprnstream::write(const unsigned char _FAR * _s, int _n)
				{ return write((const signed char _FAR *)_s, _n); }
inline oprnstream _FAR & _Cdecl oprnstream::put(char _c) {
				if( putbuf(_c) == EOF ) setstate(badbit);
				return *this;
				}
#ifdef _BIG_INLINE_
inline oprnstream _FAR & _Cdecl oprnstream::write(const signed char _FAR * _s, int _n) {
				if( ! fail() )
					if( putn((const char _FAR *)_s, _n) != _n )
						setstate(badbit);
				return *this;
				}
#endif

class _CLASSTYPE oprnstream_withassign : public oprnstream {
public:
		// does no initialization
		_Cdecl oprnstream_withassign(int flag);

virtual _Cdecl ~oprnstream_withassign();

	// gets buffer from istream and does entire initialization
	oprnstream_withassign _FAR & _Cdecl operator= (oprnstream _FAR &);

	// associates streambuf with stream and does entire initialization
	oprnstream_withassign _FAR & _Cdecl operator= (streambuf _FAR *);
};

/*
 * Manipulators
 */
oprnstream _FAR & _Cdecl endl(oprnstream _FAR &); // insert newline and flush
oprnstream _FAR & _Cdecl ends(oprnstream _FAR &); // insert null to terminate string
oprnstream _FAR & _Cdecl flush(oprnstream _FAR &);// flush the oprnstream


#endif // __PSSTREAM_H
