'CRC32.BAS  Last modified: 14 May 1992          Michael Barthelow 76234,713
'
'This program prompts for a filename, then forms the CRC32 of that file
'
DEFINT A-Z

CLS
DIM CrcTable&&(256)
False=0 : True=-1

'Create a disk buffer as close to 32K as memory permits
FreeMemory&=FRE(-1)
BufferLength&=FreeMemory&\4
IF BufferLength&>32000 THEN BufferLength&=32000
BufferRecordNumber=0

'Build Crc32 table of the 256 possible bytes for
'quick referral in forming larger Crc32's
FOR I=0 TO 255
  Crc&&=I
  FOR J=1 TO 8
    IF (Crc&& AND 1) THEN
      Crc&& = (Crc&& \ 2) XOR 3988292384
    ELSE
      Crc&& = Crc&& \ 2
    END IF
  NEXT J
  CrcTable&&(I)=Crc&&
NEXT I

top:

FirstEntry=True : RecordEnd=False
INPUT"File to check: ",FileName$

Crc32&&=4294967295        'Initialize the Crc to all ones: &HFFFFFFFF

'Form the CRC32
DO
 Temp1&&=(Crc32&& \ 256) AND 16777215
 Temp2&&=CrcTable&&(((Crc32&& AND 65535) XOR GetChar) AND &HFF)
 Crc32&&=Temp1&& XOR Temp2&&
LOOP UNTIL RecordEnd=True

Crc32&&=Crc32&& XOR 4294967295    'Invert the final Crc32

'The HEX$(nnnnn) function doesn't work for quad integers (it will in PB3)
'so you have to split the CRC32 in order to print a Hex representation
TopHalf$    = HEX$(Crc32&& \ 65536)
BottomHalf$ = HEX$(Crc32&& MOD 65536)
PRINT"Crc32&&=" ; TopHalf$ ; BottomHalf$

INPUT"Check another file? (y or n): ",response$
IF response$="y" OR response$="Y" THEN GOTO top

END


FUNCTION GetChar
'********************************* GetChar ***********************************
'This function returns the ASCII # of the next character in the current file
'*****************************************************************************
SHARED Char$,False,FirstEntry,Pointer,FileRecord$
SHARED FileName$,RecordNumber,True,RecordEnd,BufferLength&
STATIC FileLength&,CharCount&
LOCAL Record$

IF FirstEntry=True THEN
   CharCount&=1
   Pointer=1
   FirstEntry=False
   RecordNumber=1
   OPEN FileName$ FOR RANDOM AS #1 LEN=BufferLength&
   FileLength&=LOF(1)
   FIELD #1, BufferLength& AS Record$
   GET #1,RecordNumber
   FileRecord$=Record$
   CLOSE #1
ELSE
   INCR CharCount&
   INCR Pointer
   IF Pointer>BufferLength& THEN
      INCR RecordNumber
      Pointer=1
      OPEN FileName$ FOR RANDOM AS #1 LEN=BufferLength&
      FIELD #1, BufferLength& AS Record$
      GET #1,RecordNumber
      FileRecord$=Record$
      CLOSE #1
   END IF
END IF

IF CharCount&=FileLength& THEN RecordEnd=True
Char$=MID$(FileRecord$,Pointer,1)
GetChar=ASCII(Char$)

END FUNCTION  'GetChar
