{   Intro Fire Rountes Source File             }
{   PHRO!                                      }
{   Phred/OTM                                  }
{   achalfin@uceng.uc.edu                      }
{   DO NOT DISTRIBUTE THIS SOURCE FILE         }
Unit Fire;
{$G+}

Interface

Procedure StartFire;
Procedure ENVPhro;

Implementation

Uses Palettes, Pcx, VecData, Vector;

Type
  tBuffer = Array[0..75*320] of Byte;
  pBuffer = ^tBuffer;

Var
  FireBuffer : pBuffer;

Procedure SetFPalette(P : Pointer);

Type
  RGB = Record
    r, g, b : Byte;
  End;
  Pal = Array[0..255] of RGB;

Var
  Palette : Pal;
  Count : Integer;

Begin
  Move(P^, Palette, 768);
  For Count := 0 to 255 do
    Begin
      Port[$3c8] := Count;
      Port[$3c9] := Palette[Count].r;
      Port[$3c9] := Palette[Count].g;
      Port[$3c9] := Palette[Count].b;
    End;
End;

Procedure DoPhire(StartFire : Byte);

Var
  Count : Integer;
  Temp : Byte;
  xCount, yCount : Integer;

Begin
  For Count := 0 to 319 do
    FireBuffer^[74*320+Count] := Random(2)*StartFire;
  Asm
    Les  di,FireBuffer
    Mov  dx,di
    Add  di,74*320-1
    Xor  ax,ax
    Xor  bx,bx
   @Looper:
    Mov  al,es:[di+319]
    Mov  bl,es:[di+320]
    Add  ax,bx
    Mov  bl,es:[di+321]
    Add  ax,bx
    Mov  bl,es:[di]
    Add  ax,bx
    Shr  ax,2
    Jz @SkipDec
    Dec  ax
   @SkipDec:
    Mov  es:[di],al
    Dec  di
    Cmp  dx,di
    Jne @Looper
  End;
  For Count := 0 to 74 do
    Move(FireBuffer^[Count*320], Mem[$A000:(125+Count)*320], 320);
End;

Procedure StartFire;

Var
  Count : Integer;

Begin
  Asm
    Mov  ax,13h  { Initialize GFX mode }
    Int  10h
  End;
  New(FireBuffer);
  FillChar(FireBuffer^[0], 75*320, 0);
  SetFPalette(FirePalettePtr);
  For Count := 0 to 255 do
    DoPhire(Count);
  For Count := 0 to 255 do
    DoPhire(255);
  For Count := 255 downto 0 do
    DoPhire(Count);
  Dispose(FireBuffer);
End;

Procedure ClearPage(P : Pointer); Assembler;

Asm
  Les  di,P
  Mov  cx,16000
  db 66h; Xor  ax,ax
  db 66h; Rep Stosw
End;

Procedure CopyPage(P : Pointer); Assembler;

Asm
  Push  ds
  Mov   ax,$A000
  Mov   es,ax
  Xor   di,di
  Lds   si,P
  db 66h; Mov   cx,16000; dw 0;
  db 66h; Rep Movsw
  Pop   ds
End;

Procedure PhroVector(eMap, vPage : Pointer);

Type
  RGB = Record
    r, g, b : Byte;
  End;
  Palette = Array[0..255] of RGB;


Var
  R : Word;
  NumInPath : Integer;
  Zoom : Longint;
  Angle : Longint;
  AngleStep : Longint;
  Pal : Palette;
  Count : Integer;

Begin
  NumInPath := 50;
  SetFPalette(EnvFirePalettePtr);
  Move(EnvFirePalettePtr^, Pal, 768);
  InitVectorRoutines(900);
  LoadVectorObject(PhroVOPtr, 0, cPhongPoly);
  SelectEnable(0, 1, eMap);   { Enable Phro object }
  LoadVectorObject(DonutVOPtr, 1, cGouraudPoly);
  SelectEnable(1, 0, Nil);
  Angle := 0;
  AngleStep := ((2000-400) Shl 8) Div 512;
  Zoom := 2000;
  While Zoom > 360 do
    Begin
      Location(0, 0, 0, Zoom, 0, (Angle Shr 8) and 511, (Angle Shr 8) and 511);
      ClearPage(VPage);
      DisplayVectorObjects(Seg(VPage^));
      CopyPage(VPage);
      Angle := (Angle+AngleStep);
      Zoom := Zoom - 10;
    End;
  Location(0, 0, 0, 360, 0, 0, 1);
  ClearPage(VPage);
  DisplayVectorObjects(Seg(VPage^));
  CopyPage(VPage);

  SelectEnable(1, 1, Nil); { Enable Toroid }
  Zoom := -400;
  Angle := 0;
  AngleStep := 4;
  While (Angle < 511) do
    Begin
      Location(1, Zoom, 0, 360, Angle And 511, 0, Angle And 511);
      ClearPage(VPage);
      DisplayVectorObjects(Seg(VPage^));
      CopyPage(VPage);
      Angle := (Angle+AngleStep);
      Zoom := Zoom + 5;
      If Zoom >= 0
        Then Zoom := 0;
    End;
  Angle := 0;
  AngleStep := 4;
  For Zoom := 0 to 256 do
    Begin
      Location(0, 0, 0, 360, Angle And 511, Angle And 511, Angle And 511); { Phro rotate }
      Location(1, 0, 0, 360, Angle And 511, 0, Angle And 511);
      ClearPage(VPage);
      DisplayVectorObjects(Seg(VPage^));
      CopyPage(VPage);
      Angle := (Angle+AngleStep);
    End;
  Zoom := 0;
  Angle := 0;
  While (Zoom < 400) do
    Begin
      Location(0, 0, Zoom, 360, 0, 0, Angle And 511);
      ClearPage(VPage);
      DisplayVectorObjects(Seg(VPage^));
      CopyPage(VPage);
      Angle := Angle + AngleStep;
      Zoom := Zoom + 5;
    End;
  SelectEnable(0, 0, Nil); { Disable "Phro" }
  { do toroid Zoom in and Palette fade to white }
  Zoom := 360;
  Angle := 0;
  While Zoom > 213 do
    Begin
      Location(1, 0, 0, Zoom, Angle and 511, 0, Angle And 511);
      ClearPage(VPage);
      DisplayVectorObjects(Seg(VPage^));
      CopyPage(VPage);
      Angle := Angle + AngleStep;
      Zoom := Zoom - 3;
    End;
  While Zoom > 150 do
    Begin
      For Count := 0 to 255 do
        Begin
          If Pal[Count].r < 63
            Then Inc(Pal[Count].r);
          If Pal[Count].g < 63
            Then Inc(Pal[Count].g);
          If Pal[Count].b < 63
            Then Inc(Pal[Count].b);
        End;
      Location(1, 0, 0, Zoom, Angle and 511, 0, Angle And 511);
      ClearPage(VPage);
      DisplayVectorObjects(Seg(VPage^));
      CopyPage(VPage);
      Asm
        Mov  dx,$3da
       @Looper:
        In   al,dx
        And  al,8
        Jz  @Looper
      End;
      For Count := 0 to 255 do
        Begin
          Port[$3c8] := Count;
          Port[$3c9] := Pal[Count].r;
          Port[$3c9] := Pal[Count].g;
          Port[$3c9] := Pal[Count].b;
        End;
      Angle := Angle + AngleStep;
      Zoom := Zoom - 1;
    End;
  For Count := 0 to 255 do
    Begin
      Port[$3c8] := Count;
      Port[$3c9] := 63;
      Port[$3c9] := 63;
      Port[$3c9] := 63;
    End;
  FreeVectorObject(0);
  FreeVectorObject(1);
  CloseVectorRoutines;
End;

Procedure EnvPhro;

Type
  tMap = Array[0..256*256-2] of Byte;
  pMap = ^TMap;

Var
  EnvMap : pMap;
  VPage : pMap;

Begin
  New(EnvMap);
  New(VPage);
  DeCompressPCX(EnvMap^, PhirePCXPtr^);
  PhroVector(EnvMap, VPage);
  Dispose(VPage);
  Dispose(EnvMap);
End;

End.