
//   Function to get an alphabetically sorted listing of available  //
//   drives, directories and files.                                 //
//                                                                  //
//   Written by Jay Lewis, Compuserve: 102365,3264, please write!   //
//   Public Domain - Free for use                                   //
//   Borland Turbo C++ 3.0                                          //
//   27 July 1995                                                   //

//   Dedicated to helping the amateur programmer!                   //

// required include files //
#include <dos.h>
#include <dir.h>
#include <dirent.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>

// to use as string terminator //
#define NUL '\0'
// to chop one character off of a string //
#define LAST_CHAR(str) (str)[strlen(str) - 1]

// function declarations //
void read_dir(void); // function to read and store the list //
int sort_function( const void *a, const void *b); // function to sort //

   int i, dirnum;        // loop control integers //
   int save, disk;       // disk getting contol integers //
   unsigned attrib;      // for _dos_getfileattr() //
   DIR *directory;       // name of directory pointer //
   struct dirent *ent;   // pointer to directory after stream is closed //
   char buffer[MAXPATH]; // to hold current directory name //
   char array[1000][15]; // array to store up to 1000 filenames //
			 // easiest way...  could be done dynamically //
			 // with new, malloc(), or calloc() (cool way!) //

void read_dir(void)
{
   dirnum=0; // zeroize counter //

   // start drive scan //
   save = getdisk(); // save current drive for reset when done //
   for (disk = 0;disk < 26;++disk) // for a thru z //
   { setdisk(disk); // try to set disks //
     if (disk == getdisk()) // if disk exists //
     { sprintf(array[dirnum], "a[-%c-]", disk + 'A'); // copy into array //
			    //  start with "a" to aid sorting later //
       dirnum++; // increment counter //
      }
    } setdisk(save); // set back to original disk drive //

   // start directory scan //
   if ((directory = opendir(getcwd(buffer, MAXPATH))) == NULL) // open //
   { perror("Unable to open directory");
     exit(1);
    }

   while ((ent = readdir(directory)) != NULL) // read current directory //
   { if(strcmp(ent->d_name,".") != 0) // skip parent directory (my choice) //
     { _dos_getfileattr(ent->d_name,&attrib); // get file attributes //
       if(attrib & _A_SUBDIR) // if it is a directory //
       { strcpy(array[dirnum], "b"); // start with "b" to help sort later //
	 strcat(array[dirnum], ent->d_name); // copy name into array //
	 strcat(array[dirnum],"\\"); // tack on a \ (escaped) //
	}
       else // if it is  a file //
       { strcpy(array[dirnum], "c"); // start with "c" to help sort later //
	 strcat(array[dirnum],ent->d_name); // copy name into array //
	}
       dirnum++; // increment array counter //
      }
    }
   closedir(directory); // close directory //

   // alhabetical sort with a's first (drives), then b's (directories) //
   // then c's (files) by using C++'s qsort() function //
   qsort((void *)array, dirnum, sizeof(array[0]), sort_function);

   // remove sorting aids (a's, b's and c's) //
   for(i=0; i<=dirnum; i++)
   { strrev(array[i]); // turn it around backwards //
     LAST_CHAR(array[i]) = NUL; // wipe off sorting aid character //
     strrev(array[i]); // turn forwards //
    }

   // You now have a sorted listing with drives, dir's, then files.    //
   // The entries are character strings so further processing is easy. //
   // Now you can do what ever you want to display the array to user.  //

   // drives look like:          [-A-]         //
   // directories look like:     TEMP\         //
   // files look like:           README.TXT    //
 }
int sort_function( const void *a, const void *b) // part of C++ qsort() //
{  // part of C++'s qsort() example //
   return( strcmp((char *)a,(char *)b) );
 }
// small demo program //
int main(void)
{
   int x;

   read_dir();
   printf("The first 15, or total number of entries if less than 15 follow:\n\n");
   for(x=0;(x<15);x++)
   { printf(array[x]);
     printf("\n");
     if(x==dirnum)
     break;
    }
   return 0;
 }