; H2MALLOC.ASM for ASM16
; dummy ASMLIB HEAP subroutines to interface with Turbo C
; assemble with /MX switch
; Copyright (C) 1995 Douglas Herr  all rights reserved

; This file is used ONLY when linking ASMLIB subroutines with Turbo C/C++
; or Borland C/C++.  These subroutines intercept ASMLIB calls to HALLOC,
; HREALLOC and HFREE, convert parameters to the appropriate Turbo C format
; and call the C library functions.
; These subroutines have not been tested with other C compilers.

include	model.inc

public	HALLOC, HFREE, HREALLOC
IF codesize EQ 1
extrn	_malloc:far, _free:far, _realloc:far
ELSE
extrn	_malloc:near, _free:near, _realloc:near
ENDIF

include	codeseg.inc
IF codesize EQ 1
HALLOC	proc	far
ELSE
HALLOC	proc	near
ENDIF
	push	cx
	push	dx

; _malloc expects byte request to be pushed on stack
	push	ax
	call	_malloc
	mov	bx,ax
	pop	cx			; fix stack

	pop	dx
	pop	cx
	cmp	bx,1			; set CF if memory not available
	ret
HALLOC	endp

IF codesize EQ 1
HFREE	proc	far
ELSE
HFREE	proc	near
ENDIF
	push	ax
	push	bx
	push	cx
	push	dx

	push	bx			; pointer on stack for _free
	call	_free
	pop	ax			; fix stack

	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
HFREE	endp

IF codesize EQ 1
HREALLOC	proc	far
ELSE
HREALLOC	proc	near
ENDIF
	push	ax
	push	cx
	push	dx

	push	ax			; bytes
	push	bx			; old pointer
	call	_realloc
	add	sp,4
	mov	bx,ax			; ASMLIB expects pointer in BX

	pop	dx
	pop	cx
	pop	ax
	cmp	bx,1			; set CF if failed
	ret
HREALLOC	endp

@curseg	ends
	end
