#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "modplay.inc"

unsigned int _stklen  = 0x1000;         /* set stack size to 4kB */
unsigned int _heaplen = 0x0000;         /* no heap required      */

unsigned char Key, Main_Volume;
unsigned int  Cursor_Shape;

void Init_Cursor(void)
{
 asm {
  mov     ah,3
  xor     bh,bh
  int     10h
  mov     [Cursor_Shape],cx
  mov     ah,1
  mov     cx,2020h
  int     10h
 }
}

void Restore_Cursor(void)
{
 asm {
  mov     ah,1
  mov     cx,[Cursor_Shape]
  int     10h
 }
}

void Update_Screen(void)
{
 unsigned int i,j;
 unsigned char Bar[32];
 unsigned int SongPos;

 gotoxy(1,7);
 Mod_Peak();
 for(i=0; i<Channels; i++) {
  strcpy(Bar,"");
  if (Peak[i]>1) for(j=0; j<(Peak[i]>>1); j++) Bar[j]='';
  gotoxy(2,4+i); cprintf("%s", Bar);
 }
 SongPos=Mod_Position();
 gotoxy(3,6+Channels); cprintf("Playing pattern #%d, line #%d  ", SongPos>>8, SongPos&0x00ff);
 gotoxy(62,wherey()); cprintf("Main volume: %3d%%", div(Main_Volume*100,64));
}

void main(void)
{
 Mod_Init(Detection,0,0,0);
 if (Soundcard!=0) {
  Mod_Load("DONTYOU.MOD");
  if (Channels!=0) {
   Init_Cursor();
   Main_Volume=58;
   Mod_Volume(Main_Volume);
   Mod_Play(0);
   textcolor(WHITE); textbackground(BLACK);
   clrscr();
   textbackground(BLUE); gotoxy(1,1); clreol();
   gotoxy(22,1); cprintf("SOUND WIZARDS MODULE PLAYER 'C' DEMO");
   gotoxy(1,6+Channels); clreol();
   textbackground(BLACK);
   gotoxy(36,1+Channels); cprintf("Press       up,down:     to adjust volume  ");
   gotoxy(36,2+Channels); cprintf("            left,right:  to change position");
   gotoxy(36,3+Channels); cprintf("or escape to quit this little program......");
   textbackground(BLUE);
   do {
    Update_Screen();
    Key=' ';
    if (kbhit()) Key=getch();
    if (Key==0) {       /* only allow function keys */
     Key=getch();
     switch(Key) {
      case 0x48: if (Main_Volume<64) {
                  Main_Volume+=2;
                  Mod_Volume(Main_Volume);
                 }
                 break;
      case 0x50: if (Main_Volume>0) {
                  Main_Volume-=2;
                  Mod_Volume(Main_Volume);
                 }
                 break;
      case 0x4d: Mod_Forward();
                 break;
      case 0x4b: Mod_Rewind();
                 break;
     }
    }
   } while((Mod_Status()!=0) && (Key!=27));
   gotoxy(1,9+Channels);
   Restore_Cursor();
  } else printf("\nCould not load song DONTYOU.MOD...\n");
 } else printf("\nCould not initialize hardware...");
}
