PROGRAM Example1;           { (C) 1993 John C. Leon   last updated 11/11/93 }

{Illustrates use of BTP in a real, though simple, program.  Uses the LString
 key type to facilitate use of Pascal strings.  Note that the key length must
 include room for the length byte.  Thus, the key fields below (Pascal
 strings) are sized to one less than the key length, making room for the
 length byte.  Note also that the key buffer must contain the length byte as
 well, and since we may have keys that are NOT strings, we have to actually
 do a MOVE to get the field(s) into the key buffer to avoid a type mismatch
 error.  This is because the key buffer is simply an array of char.

 Note filling of data buffer with nulls before each insertion.  While not
 strictly necessary (the length byte will force ignoring garbage after last
 significant char in any LString field), this guarantees that each field will
 contain only the characters desired.

 Recall that this program expects to find a Btrieve file named EXAMPLE in
 the current directory.  Use the CREATE1 program to create the EXAMPLE file,
 which has three keys: Key 0: 20 positions, an LString (Pascal string),
                              representing LAST NAME in this program;
                       Key 1: 10 positions, an LString (Pascal string),
                              representing FIRST NAME in this program;
                       Key 2:  8 positions, a Float (Pascal double),
                              representing Salary in this program
}


{$IFDEF production} {$D-,R-,L-,S-} {$ENDIF}
{$X+,N+,E+,A-}

USES
   BTP, BTRAPID;

TYPE
   MyFields = record
                 case integer of
                 1: (First   : string[9];  {Note keylen is 10, so string is}
                     Last    : string[19]; {sized to 1 less-room for len byte}
                     Salary  : double;
                     KeyBuf  : array[1..20] of char);{size to largest key }
                 2: (DBuffer : array[1..38] of char);{size to rec length  }
                 3: (Position: array[1..2] of word); {high word first!    }
                 end;                                {useful after GETPOS }

   TMyFile = object(BFile)
                Fields: MyFields;
                constructor Init;
                function BT(OpCode, Key: integer): integer; virtual;
                function GetPosition: longint;
                end;

VAR
   MyFile  : TMyFile;
   First   : string[9];
   Last    : string[19];
   CurrPosition: longint;

constructor TMyFile.Init;
begin
   inherited Init('example', Accel, '');              {Open file in accelerated mode.}
end;

function TMyFile.BT(OpCode, Key:integer):integer;
begin
   {Whatever you do, do NOT use Specs.RecLen as the 4th parameter in the
    Btrv call below, as it is a VAR parameter, and could be changed by
    Btrieve on return from the Btrv call!!  Thus we use a data member that is
    not a part of our encapsulated file stats.}
   DBufferLen := sizeof(Fields.DBuffer);
   BT := Btrv(OpCode, PosBlk, Fields, DBufferLen, Fields.KeyBuf, Key);
end;

function TMyFile.GetPosition: longint;
begin
   GetPosition := Fields.Position[2] + Fields.Position[1] * 65536;
end;


(* begin main program code *)
BEGIN
   if not IsBtrieveLoaded then
      begin
      writeln('Please load Btrieve before running this program ...');
      halt(1);
      end;

   MyFile.Init;
   if BStatus <> 0 then
      begin
      writeln('Error initializing ... Status: ', BStatus);
      halt(2);
      end;

   with MyFile.Fields do
      begin

      fillchar(DBuffer, sizeof(DBuffer), 0);
      First := 'Sara';
      Last  := 'Leon';
      Salary := 20000;
      move(Last[0], KeyBuf, sizeof(Last)+1);
      BStatus := MyFile.BT(BInsert, 0);

      fillchar(DBuffer, sizeof(DBuffer), 0);
      First := 'John';
      Last  := 'Leon';
      Salary := 10000;
      move(Last[0], KeyBuf, sizeof(Last)+1);
      BStatus := MyFile.BT(BInsert, 0);

      end;

   MyFile.BT(BGetFirst, 1);
   with MyFile.Fields do
      begin
      writeln;
      writeln('Status of Get First on First Name index: ', BStatus);
      writeln('Last Name retrieved: ', Last);
      writeln('First Name retrieved: ', First);
      writeln('Salary retrieved: ', Salary:5:2);
      end;

   MyFile.BT(BGetNext, 1);
   with MyFile.Fields do
      begin
      writeln;
      writeln('Status of Get Next: ', BStatus);
      writeln('Last Name retrieved on a Get Next: ', Last);
      writeln('First Name retrieved on a Get Next: ', First);
      writeln('Salary retrieved on a Get Next: ', Salary:5:2);
      end;

   MyFile.BT(BGetFirst, 2);
   with MyFile.Fields do
      begin
      writeln;
      writeln('Status of Get First on Salary Index: ', BStatus);
      writeln('Last Name retrieved: ', Last);
      writeln('First Name retrieved: ', First);
      writeln('Salary retrieved: ', Salary:5:2);
      end;

   MyFile.BT(BGetLast, 1);
   MyFile.BT(BGetPos, 1);
   with MyFile.Fields do
      begin
      CurrPosition :=  MyFile.GetPosition;
      writeln;
      writeln('Physical position of last record in First Name index: ', CurrPosition);
      end;

   MyFile.Stat;
   writeln;
   writeln('Total number of records: ', MyFile.NumRecs);
   MyFile.Close;

END.