PROGRAM Clone;                 { (C) 1993 John C. Leon   last updated 6/8/93 }

{$IFDEF production} {$D-,R-,L-,S-} {$ENDIF}
{$X+,A-}

USES
   Dos, BTP;

CONST
   NOTICE = 'CLONE 2.0  (C) 1993 John C. Leon.  All Rights Reserved.';

VAR
   OrgName, CopyName : string[79];
   OwnerName         : string;
   Supplementals     : string;
   Counter, Option   : integer;
   OrgFile           : PBFile;
   CopyFile          : File;
   Response          : string;
   DirInfo           : SearchRec;

BEGIN
   if not IsBtrieveLoaded then
      begin
      writeln('Please load Btrieve before running this program.');
      halt(1);
      end;

   writeln;
   writeln(NOTICE);
   writeln;

   if (paramstr(1) = '?') or (paramstr(1) = '/?') or (paramstr(1) = '-?') or
      (paramcount < 2) then
      begin
      writeln('USAGE: CLONE source_file target_file [drop|retain|none] [owner]');
      writeln;
      writeln('CLONE will duplicate the structure of an existing Btrieve file.');
      writeln('The target table will hold no records.  If the source file has');
      writeln('supplemental indexes, you can choose to RETAIN them as');
      writeln('supplemental indexes (the default), DROP them, or make them');
      writeln('permanent indexes.  Specifying NONE will retain existing');
      writeln('supplemental indexes as PERMANENT indexes in the clone.');
      writeln('If an owner name exists for the source file, specify that name');
      writeln('as the fourth command line parameter.  The target file will then');
      writeln('be created (without an owner name).');
      halt(2);
      end;

   OrgName := paramstr(1); CopyName := paramstr(2);
   for Counter := 1 to length(OrgName) do
      OrgName[Counter] := upcase(OrgName[Counter]);
   for Counter := 1 to length(CopyName) do
      CopyName[Counter] := upcase(CopyName[Counter]);
   if paramcount >= 3 then
      begin
      Supplementals := paramstr(3);
      for Counter := 1 to length(Supplementals) do
         Supplementals[Counter] := upcase(Supplementals[Counter]);
      if ((Supplementals <> 'DROP') and (Supplementals <> 'RETAIN') and
         (Supplementals <> 'NONE')) then
         Supplementals := 'RETAIN';
      end
   else
      Supplementals := 'RETAIN';      {note default is to retain supp indexes}
   if paramcount >= 4 then
      OwnerName := paramstr(4)
   else
      OwnerName := '';

   if Supplementals = 'DROP'       then Option := Drop   else
      if Supplementals = 'RETAIN'  then Option := Retain else
         if Supplementals = 'NONE' then Option := None;

   {Verify that source file exists and is a Btrieve file before continuing. }
   {While the CloneFile function would return a proper status error code if }
   {the source file was not found, it would be something not entirely       }
   {indicative of the type of i/o error.  The following is much more exact. }

   OrgFile := new(PBFile, Init(OrgName, ReadOnly, OwnerName));
   if BStatus = FileNotFound then
      begin
      writeln;
      writeln('Source file ', OrgName, ' not found.');
      writeln;
      dispose(OrgFile, Done);
      halt(3);
      end;
   if BStatus = 0 then
      begin
      OrgFile^.Close;
      dispose(OrgFile, Done);
      end
      else
      begin
      writeln;
      writeln('Btrieve cannot open ', OrgName, '.  Status = ', BStatus);
      dispose(OrgFile, Done);
      halt(4);
      end;

   {If target file exists, whether as a Btrieve file or not, }
   {get confirmation before overwriting.                     }

   FindFirst(CopyName, Archive, DirInfo);
   if doserror = 0 then
      begin
      writeln;
      write('Target file ', CopyName, ' exists.  Overwrite? (Y/N): ');
      readln(Response);
      Response := upcase(Response[1]);
      if Response = 'N' then
         halt(5);
      if Response <> 'Y' then
         begin
         writeln;
         writeln('Improper response...CLONE aborted.');
         halt(6);
         end;
      end;

   if CloneFile(OrgName, CopyName, Option, OwnerName) = 0 then
      writeln(OrgName, ' successfully cloned as ', CopyName)
      else
      begin
      writeln('Clone operation failed.  Status = ', BStatus);
      halt(7);
      end;
END.
