{*************************************************************************
**
**  Copyright 1982-1994 Btrieve Technologies, Inc. All Rights Reserved
**
*************************************************************************}
{***********************************************************************
   BTRAPID.PAS
      This is the PASCAL unit for DOS Btrieve to be called by Borland Turbo
      PASCAL v5.x-7.0.

      Before your application can use this program, it must be compiled to
      a '.tpu' file.  See the Borland documentation for how to create a
      '.tpu' file.  Also, see 'btrsampd.pas' for a sample application which
      references 'btrapid.tpu'.

      This routine sets up the parameter block expected by Btrieve, and
      issues interrupt 7B.

      Calling procedure:

      STAT := BTRV( operation, positionBlock, dataBuffer, dataLen,
                    keyBuffer, keyNumber );

        where
          operation      - Btrieve Operation
          positionBlock  - pointer to 128-byte position block
          dataBuffer     - pointer to data buffer
          dataLen        - pointer to length in bytes of data buffer
          keyBuffer      - pointer to keyBuffer ( 255 bytes in size )
          KeyNumber      - key Number

      There should NEVER be any string variables declared in the
      data or key records, because strings store an extra byte for
      the length, which affects the total size of the record.

      IMPORTANT
      ---------
      Btrieve Technologies, Inc., invites you to modify this file
      if you find it necessary for your particular situation.  However,
      we cannot provide technical support for this module if you
      do modify it.

      This module is current as of 06/08/94.

************************************************************************}
UNIT btrapid;
{$A-}    {Added by J. Leon - word alignment off}

{***********************************************************************
   Interface Section
*************************************************************************}
INTERFACE

USES DOS;

FUNCTION BTRV(
                operation      : WORD;
            VAR positionBlock;
            VAR dataBuffer;
            VAR dataLen        : WORD;
            VAR keyBuffer;
                keyNumber      : INTEGER ) : INTEGER;


{***********************************************************************
   Implementation Section
*************************************************************************}
IMPLEMENTATION

{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$V-}    {Strict var-string off}

FUNCTION BTRV(   operation      : WORD;
             VAR positionBlock;
             VAR dataBuffer;
             VAR dataLen        : WORD;
             VAR keyBuffer;
                 keyNumber      : INTEGER ): INTEGER;

CONST
     VAR_ID             = $6176;   {id for variable length records - 'va'}
     BTR_INT            = $7B;
     BTR_OFFSET         = $0033;

TYPE
     ADDR32 = RECORD        { 32 bit address }
        OFFSET: WORD;       { &&&old->integer }
        SEGMENT: WORD;      { &&&used->integer }
     END;

     BTR_PARMS = RECORD
        USER_BUF_ADDR:   ADDR32;       {data buffer address}
        USER_BUF_LEN:    WORD;         {data buffer length}
        USER_CUR_ADDR:   ADDR32;       {currency block address}
        USER_FCB_ADDR:   ADDR32;       {file control block address}
        USER_FUNCTION:   WORD;         {Btrieve operation}
        USER_KEY_ADDR:   ADDR32;       {key buffer address}
        USER_KEY_LENGTH: BYTE;         {key buffer length}
        USER_KEY_NUMBER: SHORTINT;     {key number&&&old->BYTE}
        USER_STAT_ADDR:  ADDR32;       {return status address}
        XFACE_ID:        INTEGER;      {language interface id}
     end;

VAR
     STAT:  INTEGER;             {Btrieve status code}
     XDATA: BTR_PARMS;           {Btrieve parameter block}
     REGS:  DOS.REGISTERS;       {register structure used on interrrupt call}
     DONE:  BOOLEAN;

BEGIN
     REGS.AX := $3500 + BTR_INT;
     INTR ($21, REGS);
     IF (REGS.BX <> BTR_OFFSET) THEN          {make sure Btrieve is installed}
        STAT := 20
     ELSE
        { If Btrieve is installed, make the call. }
        BEGIN
           WITH XDATA DO
              BEGIN
                 USER_BUF_ADDR.SEGMENT  := SEG (dataBuffer);
                 USER_BUF_ADDR.OFFSET   := OFS (dataBuffer);
                 USER_BUF_LEN           := dataLen;
                 USER_FCB_ADDR.SEGMENT  := SEG (positionBlock);
                 USER_FCB_ADDR.OFFSET   := OFS (positionBlock);
                 USER_CUR_ADDR.SEGMENT  := USER_FCB_ADDR.SEGMENT;
                 USER_CUR_ADDR.OFFSET   := USER_FCB_ADDR.OFFSET+38;
                 USER_FUNCTION          := operation;
                 USER_KEY_ADDR.SEGMENT  := SEG (keyBuffer);
                 USER_KEY_ADDR.OFFSET   := OFS (keyBuffer);
                 USER_KEY_LENGTH        := 255;{keyBuffer must hold 255 bytes}
                 USER_KEY_NUMBER        := keyNumber;
                 USER_STAT_ADDR.SEGMENT := SEG (STAT);
                 USER_STAT_ADDR.OFFSET  := OFS (STAT);    {set status address}
                 XFACE_ID               := VAR_ID;        {set lamguage id}
              END;

           REGS.DX := OFS (XDATA);
           REGS.DS := SEG (XDATA);

           INTR (BTR_INT, REGS);
           DATALEN := XDATA.USER_BUF_LEN;
        END;
     BTRV := STAT;
END;
{$B-}
END.
