Option Explicit

' ===============================================================
' = VBossAPI.DLL v02.00.01 Interface Declarations               =
' ===============================================================
'
'  @@    @@ @@@@@@                             @    @@@@@@  @@@@
'  @@    @@  @@  @@                           @@@    @@  @@  @@
'  @@    @@  @@  @@  @@@@@   @@@@@   @@@@@   @@ @@   @@  @@  @@
'  @@    @@  @@@@@  @@   @@ @@   @@ @@   @@ @@   @@  @@  @@  @@
'  @@    @@  @@  @@ @@   @@  @@@     @@@    @@@@@@@  @@@@@   @@
'   @@  @@   @@  @@ @@   @@    @@@     @@@  @@   @@  @@      @@
'    @@@@    @@  @@ @@   @@ @@   @@ @@   @@ @@   @@  @@      @@
'     @@    @@@@@@   @@@@@   @@@@@   @@@@@  @@   @@ @@@@    @@@@
'
' ...............................................................
' . V isual                                                     .
' . B asic                                                      .
' . O ptimized                                                  .
' . S cript                                                     .
' . S upport                                                    .
' . A pplication                                                .
' . P rogramming                                                .
' . I nterface                                                  .
' ===============================================================
' = Copyright  1994,95 Greg Truesdell                          =
' ===============================================================

' ===============================================================
' = RegisterVBossAPI()                                          =
' =     Used to register the DLL                                =
' ===============================================================
'
Declare Function RegisterVBossAPI Lib "VBossAPI.DLL" (ByVal UserID As String, ByVal RegID As String) As Integer
Declare Function CreateScrObject Lib "VBossAPI.DLL" () As Integer
Declare Sub DestroyScrObject Lib "VBossAPI.DLL" (ByVal idx As Integer)

' ===============================================================
' = SetParseOption()                                            =
' =   Used to set special parsing engine options                =
' ===============================================================
Declare Sub SetParseOption Lib "VBossAPI.DLL" (ByVal POption As Integer, ByVal OnOff As Integer)
    '
    ' Parsing Options
    '
    Global Const PO_STRINGS = 0   ' determines if the parse should recognize strings
				  ' as '' or "".  If so, the parser will return
				  ' NT_STRING_CONST when a string is parsed.
'
' VBossAPI Limits Constants
'
Global Const OSS_MAX_WORD_LEN = 255         '{ maximum word length }

' ***************************************************************************************
' * Expression Evaluation Routines                                                      *
' *                                                                                     *
' *     Evaluate, Test and return Error information.                                    *
' *                                                                                     *
' ***************************************************************************************

' ===============================================================
' = EvalExpression()                                            =
' =     Evaluates REAL & INT expressions in infix notation and  =
' =     supports */+- and ABS, ARCTAN, COS, EXP, LN, SQR and    =
' =     SQRT.                                                   =
' =                                                             =
' =     Evaluates the text formula in ExprStr and returns the   =
' =     text representation of the answer.  Supports the        =
' =     dynamic allocation of variables and can use variables   =
' =     already declared.                                       =
' ===============================================================
'
Declare Function EvalExpression Lib "VBossAPI.DLL" (ByVal ExprStr As String, rc As Integer) As String

' ===============================================================
' = TestNumExpr()                                               =
' =     Test the relation between two numeric expressions.      =
' ===============================================================
'
Declare Function TestNumExpr Lib "VBOSSAPI.DLL" (ByVal LExpr As String, ByVal Op As String, ByVal RExpr As String, Success As Integer) As Integer

' ===============================================================
' = EvalErrorString()                                           =
' =     Returns the error string describing the last error in   =
' =     the evaluation of an expression by EvalExpression. If   =
' =     EvalExpression returns FALSE in <rc>, then use this     =
' =     call to determine the cause of the error.  The          =
' =     internal error code is RETURNED in <errcode>            =
' =                                                             =
' = Note:   The error code and error string are reset after     =
' =         a call to this function.                            =
' ===============================================================
'
Declare Function EvalErrorString Lib "VBossAPI.DLL" (errcode As Integer) As String

    '
    '  EvalExpression Error Codes (returned by EvalErrorString())
    '
    Global Const EXPR_SYNTAX_ERROR = 1
    Global Const EXPR_PARAMETER_MISSING = 2
    Global Const EXPR_PARAMETER_COUNT_ERROR = 3
    Global Const EXPR_INVALID_PARAMETER = 4
    Global Const EXPR_OVERFLOW = 5
    Global Const EXPR_COMMA_MISSING = 6
    Global Const EXPR_MISSING_RPAREN = 7
    Global Const EXPR_TYPE_MISMATCH = 8
    Global Const EXPR_INVALID_IDENTIFIER = 9
    Global Const EXPR_PARAMETERS_NOT_ALLOWED = 10
    Global Const EXPR_EXPECTED_FACTOR = 11
    Global Const EXPR_EXPECTED_TERM = 12
    Global Const EXPR_EXPECTED_EXPRESSION = 13
    Global Const EXPR_ZERO_DIVIDE = 14
    Global Const EXPR_OUT_OF_MEMORY = 15
    Global Const EXPR_GARBAGE_FOLLOWS = 16
    Global Const EXPR_VARIABLE_EQUATE_ERROR = 17
    Global Const EXPR_INVALID_FUNCTION = 18

' ***************************************************************************************
' * Token Parsing Support Routines                                                      *
' *                                                                                     *
' *     This section defines the Token Parsing Routines.  Token parsing uses a number   *
' *     of internal defaults.  These include:                                           *
' *                                                                                     *
' *         Word Delimiters:    All characters from Chr(1) to Chr(32)                   *
' *         Operator Tokens:    +-*/"';:[]{}()!@#$%^&=<>,                               *
' *                                                                                     *
' *             Operator tokens reserve the first 32 token codes (0..31), so your       *
' *             token codes must start at 32+                                           *
' *                                                                                     *
' ***************************************************************************************

' ===============================================================
' = AddKeyword()                                                =
' =     Adds a keyword and related keycode to the keyword list  =
' ===============================================================
Declare Function AddKeyword Lib "VBossAPI.DLL" (ByVal kw As String, ByVal kc As Integer) As Integer
    '
    '   AddKeyword() Return Codes
    '
    Global Const AKW_NO_MORE_ROOM = -1      '{ no more keyword space }
    Global Const AKW_INVALID_CHAR = -2      '{ invalid character in keyword }
    Global Const AKW_DUPLICATE_KEYWORD = -3 '{ duplicate keyword }
    Global Const AKW_KEYWORD_TOO_LONG = -4  '{ keyword too long }
    Global Const AKW_INVALID_TOKEN = -5     '{ invalid token (keycode) value }
					    '{ - negative numbers not allowed }
    Global Const AKW_TYPE_MISMATCH = -6     '{ AddVariable() type mismatch }
    Global Const AKW_OVERFLOW = -7          '{ AddVariable() overflow }
    '
    '   AddKeyword() Limits
    '
    Global Const AKW_MAX_KEYWORD_LEN = 16   '{ maximum keyword length }
    Global Const AKW_MAX_KEYWORDS = 256     '{ maximum number of keywords }

' ===============================================================
' = NextToken()                                                 =
' =     Starting at <start> returns the next token code found   =
' =     in <st> in <token>. <start> is returned with the next   =
' =     character index in the string. The function returns     =
' =     the token text.                                         =
' =                                                             =
' = Note:                                                       =
' =         The <token> parameter must be an integer variable   =
' =         since this function returns the token value         =
' =         associated with the token found. See constant       =
' =         declarations below.                                 =
' ===============================================================
' = PeekNextToken() gets the next token without updating the    =
' = <start> (character index) variable                          =
' ===============================================================
'
Declare Function NextToken Lib "VBossAPI.DLL" (start As Integer, ByVal st As String, Token As Integer) As String
Declare Function PeekNextToken Lib "VBossAPI.DLL" (ByVal start As Integer, ByVal st As String, Token As Integer) As String
    '
    '   NextToken Return Codes (in <token>)
    '
    '   Note: Positive numbers >= NT_MAX_OPERATORS are valid tokens
    '
    Global Const NT_MAX_OPERATORS = 32      ' reserved operator tokens
    Global Const NT_PAST_EOL = -1           '{ end of the line }
    Global Const NT_NO_KEYWORDS = -2        '{ no keywords in keyword DB }
    Global Const NT_TOKEN_NOTFOUND = -3     '{ next word can not be tokenized }
    Global Const NT_NO_FREE_MEMORY = -4     '{ no heap available for buffer }
    Global Const NT_VARIABLE_FOUND = -5     '{ keyword found was a variable }
    Global Const NT_USER_ERROR = -99        '{ added as a convience, not used internally }
    Global Const NT_LABEL_FOUND = -6        '{ keyword parsed was a label name }
    Global Const NT_FUNCTION = -7           '{ keyword parsed was a function name }
    Global Const NT_PROCEDURE = -8          '{ keyword parsed was a procedure name }
    Global Const NT_NUMERIC_CONST = -9
    Global Const NT_STRING_CONST = -10
    Global Const NT_MATH_FUNCTION = -11


    '
    '  Operator Constants - Tokens returned by NextToken() for operators
    '
    '  + - * / " ' ; : [ ] { } ( ) ! @ # $ % ^ & = < > ,
    '
    Global Const NT_PLUS = 1
    Global Const NT_MINUS = 2
    Global Const NT_TIMES = 3
    Global Const NT_DIVIDE = 4
    Global Const NT_DBL_QUOTE = 5
    Global Const NT_SNG_QUOTE = 6
    Global Const NT_SEMICOLON = 7
    Global Const NT_COLON = 8
    Global Const NT_LEFTBRACKET = 9
    Global Const NT_RIGHTBRACKET = 10
    Global Const NT_LEFTBRACE = 11
    Global Const NT_RIGHTBRACE = 12
    Global Const NT_LEFTPAREN = 13
    Global Const NT_RIGHTPAREN = 14
    Global Const NT_EXCLAMATION = 15
    Global Const NT_AT = 16
    Global Const NT_POUND = 17
    Global Const NT_DOLLAR = 18
    Global Const NT_PERCENT = 19
    Global Const NT_CARET = 20
    Global Const NT_AMPERSAND = 21
    Global Const NT_EQUAL = 22
    Global Const NT_LESSTHAN = 23
    Global Const NT_GREATERTHAN = 24
    Global Const NT_COMMA = 25

' ===============================================================
' = KeywordCount()                                              =
' =     Returns the number of keywords in the keyword DB.       =
' ===============================================================
'
Declare Function KeywordCount% Lib "VBossAPI.DLL" ()

' ===============================================================
' = GetKeyword()                                                =
' =     Return the keyword text for keyword #<idx>.             =
' =                                                             =
' = Note:                                                       =
' =         This function returns the keyword text for the      =
' =         <idx>-th entry in the keyword list, NOT by the      =
' =         keyword's token value.  Operators are not included  =
' =         in the keyword list.                                =
' =                                                             =
' =         Use with KeywordCount() to locate all keywords      =
' =         in the keyword list.                                =
' =                                                             =
' =         The keyword list is zero based (0 to MAX_KEYWORDS-1)=
' ===============================================================
'
Declare Function GetKeyword Lib "VBossAPI.DLL" (ByVal idx As Integer) As String

' ===============================================================
' = GetKeywordToken()                                           =
' =     Return the keyword token for keyword <kw>.              =
' =                                                             =
' = Note:                                                       =
' =         This function returns the token value of a keyword. =
' =         The token value is the value you passed in the      =
' =         AddKeyword() function <kc> parameter                =
' ===============================================================
'
Declare Function GetKeywordToken Lib "VBossAPI.DLL" (ByVal kw As String) As Integer

' ===============================================================
' = GetTokenKeyword()                                           =
' =     Returns the text Keyword for the token code passed.     =
' =                                                             =
' = Note:                                                       =
' =         This function recalls the text Keyword based on the =
' =         token value you passed in the AddKeyword()          =
' =         function                                            =
' ===============================================================
'
Declare Function GetTokenKeyword Lib "VBossAPI.DLL" (ByVal Token As Integer) As String


' ===============================================================
' = SaveKeywords()                                              =
' =     Save the keyword list to file                           =
' =     Returns 0 if successful, -1 if not                      =
' ===============================================================
'
' Keyword file Record type
'
Type KeywordRecord

    KeywordLen  As String * 1   ' byte value 0..16
    KeywordStr  As String * 16
    KeyToken    As Integer
    Reserved1   As Integer
    Reserved2   As Long

End Type
'
Declare Function SaveKeywords Lib "VBossAPI.DLL" (ByVal filename As String) As Integer

' ===============================================================
' = LoadKeywords()                                              =
' =     Load the keyword list from file                         =
' =     Returns 0 if successful, -1 if not                      =
' ===============================================================
'
Declare Function LoadKeywords Lib "VBossAPI.DLL" (ByVal filename As String) As Integer

' ===============================================================
' = ZapKeywords()                                               =
' =     Erases all keywords.                                    =
' ===============================================================
'
Declare Sub ZapKeywords Lib "VBossAPI.DLL" ()

' ===============================================================
' = NT_CodeString()                                             =
' =     Decode the context of a token code                      =
' ===============================================================
'
Declare Function NT_CodeString Lib "VBossAPI.DLL" (ByVal Token As Integer) As String

' ===============================================================
' = NT_Operators()                                              =
' =     Returns a string containing the default operators list. =
' ===============================================================
Declare Function NT_Operators Lib "VBossAPI.DLL" () As String
Declare Sub SetOperators Lib "VBossAPI.DLL" (ByVal OpList As String)

' ===============================================================
' = DefTokenDelims()                                            =
' =     Returns a VBStr with the default token delimiters.      =
' ===============================================================
'
Declare Function DefTokenDelims Lib "VBossAPI.DLL" () As String
Declare Sub SetDelimiters Lib "VBossAPI.DLL" (ByVal delims As String)

' ***************************************************************************************
' * Variable Related Functions                                                          *
' ***************************************************************************************

' ===============================================================
' = AddVariable()                                               =
' =     Adds a new variable to the variable DB. The data type   =
' =     is determined by the value of <vtype>. The data to be   =
' =     stored is provided as a string. <vdata>                 =
' =                                                             =
' = Note:                                                       =
' =         See AKW_* return codes. This function returns the   =
' =         same error return codes as AddKeyword()             =
' =
' ===============================================================
'
Declare Function AddVariable Lib "VBossAPI.DLL" (ByVal VName As String, ByVal vtype As Integer, ByVal vdata As String) As Integer
    '
    ' Variable Type Constants
    '
    Global Const VTNONE = 0
    Global Const VTSTRING = 1
    Global Const VTINTEGER = 2
    Global Const VTFLOAT = 3
    Global Const VTPROCEDURE = 4    ' defined to help implement procedures by name
    Global Const VTFUNCTION = 5     ' defined to help implement functions by name
    Global Const VTLABEL = 6        ' defined to help implement labels


' ===============================================================
' = VariableCount()                                             =
' =     Returns the number of variables in the variable DB.     =
' ===============================================================
'
Declare Function VariableCount% Lib "VBossAPI.DLL" ()

' ===============================================================
' = GetVariable()                                               =
' =     Searches the variable list for <vname>.                 =
' =                                                             =
' =     If found returns the variable type in <vtype> and a     =
' =     string containing a text representation of the variable =
' =     contents.                                               =
' =                                                             =
' =     if NOT found, returns -1 in vartype and a null string.  =
' =                                                             =
' ===============================================================
'
Declare Function GetVariable Lib "VBossAPI.DLL" (ByVal VName As String, vtype As Integer) As String

' ===============================================================
' = PeekVariable()                                              =
' =   Returns the name and type of the idx'th variable in the   =
' =  variable database                                          =
' ===============================================================
Declare Function PeekVariable Lib "VBossAPI.DLL" (ByVal idx As Integer, vtype As Integer) As String


' ===============================================================
' = SetVariable()                                               =
' =     Sets the variable <vname> to the new value in <vdata>.  =
' =     <vdata> is a string, so the variable contents are       =
' =     checked for consistancy with the variable type.         =
' =                                                             =
' =     Returns an error code if the variable type is a         =
' =     mismatch or if the variable doesnot exist.              =
' =                                                             =
' =     Otherwise returns the variable type on success.         =
' ===============================================================
'
Declare Function SetVariable Lib "VBossAPI.DLL" (ByVal VName As String, ByVal vdata As String) As Integer

' ===============================================================
' = KillVariable()                                              =
' =   Zaps a specific variable                                  =
' = KillVariablesFrom()                                         =
' =   Zaps a specific variable and all variables created after  =
' =   it.                                                       =
' = ZapVariables()                                              =
' =   Erases all variables.                                     =
' ===============================================================
'
Declare Sub KillVariable Lib "VBossAPI.DLL" (ByVal VName As String)
Declare Sub KillVariablesFrom Lib "VBossAPI.DLL" (ByVal VName As String)
Declare Sub ZapVariables Lib "VBossAPI.DLL" ()

' ***************************************************************************************
' * Word Parsing Support Routines                                                       *
' *                                                                                     *
' *     This section defines the Word Parsing Routines.  Word parsing differs from      *
' *     token parsing in that no default assumptions are made as to what delimits       *
' *     a word.  Most functions require a string containing the delimiters you want     *
' *     to use.                                                                         *
' *                                                                                     *
' * Note:                                                                               *
' *         A word is defined as up to 255 characters delimited by the delimiter        *
' *         set.  Any set of characters located that is > 255 will be truncated.        *
' ***************************************************************************************

' ===============================================================
' = ParseStr()                                                  =
' =     Parse string <st> starting at zero-based character      =
' =     <start> using <delims> as a string of word delimiters.  =
' =                                                             =
' = Returns integer <start> with index to next word or -1 if no =
' =     more.                                                   =
' ===============================================================
'
Declare Function ParseStr Lib "VBossAPI.DLL" (start As Integer, ByVal st As String, ByVal delims As String) As String

' ===============================================================
' = ParseUntil()                                                =
' =     Parse string st starting at zero-based character start  =
' =     using cset as a string of word delimiters.  Stop at     =
' =     the first occurance of any character in the cset.       =
' =                                                             =
' = Returns integer <start> with index to next word or -1 if no =
' =     more.                                                   =
' ===============================================================
'
Declare Function ParseUntil Lib "VBossAPI.DLL" (start As Integer, ByVal st As String, ByVal cset As String) As String

' ===============================================================
' = WordCount()                                                 =
' =     Count the number of words in string <st> using the      =
' =     string <delims> as word delimiters                      =
' ===============================================================
'
Declare Function WordCount Lib "VBossAPI.DLL" (ByVal st As String, ByVal delims As String) As Integer

' ===============================================================
' = GetWordAt()                                                 =
' =     Return word number <idx> in string <st> using <delims>  =
' =     as a set of word delimiters                             =
' ===============================================================
'
Declare Function GetWordAt Lib "VBossAPI.DLL" (ByVal idx As Integer, ByVal st As String, ByVal delims As String) As String

' ===============================================================
' = LocateWord()                                                =
' =     Return the character index in <str> of the <idx>th word =
' =     (in <str>).                                             =
' ===============================================================
'
Declare Function LocateWord Lib "VBossAPI.DLL" (ByVal idx As Integer, ByVal st As String, ByVal delims As String) As Integer


' ***************************************************************************************
' * Misc. String Functions                                                              *
' ***************************************************************************************

' =======================================================================
' = LPGetVBStr()                                                        =
' =     Convert the zero-terminated string (by pointer) to a VB String. =
' =======================================================================
'
Declare Function LPGetVBStr Lib "VBossAPI" (ByVal pStr As Long) As String

' =======================================================================
' = VBStrGetLP()                                                        =
' =     Return a pointer to the lpsz string in a VB String.             =
' =======================================================================
'
Declare Function VBStrGetLP Lib "VBossAPI" (ByVal pStr As String) As Long

' ===============================================================
' = PackSpaces()                                                =
' =     Pack multiple spaces into one space in string <st>      =
' =                                                             =
' = Note: Tabs are packed as well (single space)                =
' ===============================================================
'
Declare Function PackSpaces Lib "VBossAPI.DLL" (ByVal st As String) As String


' ===============================================================
' = FullPath()                                                  =
' =     Returns the expanded file path for the filename <fn>    =
' ===============================================================
'
Declare Function FullPath Lib "VBossAPI.DLL" (ByVal fn As String) As String

' ===============================================================
' = NameOnly()                                                  =
' =     Returns the name part of the filename <fn>              =
' ===============================================================
'
Declare Function NameOnly Lib "VBossAPI.DLL" (ByVal fn As String) As String

' ===============================================================
' = ExtOnly()                                                   =
' =     Returns the extension (.ext) for the filename <fn>      =
' ===============================================================
'
Declare Function ExtOnly Lib "VBossAPI.DLL" (ByVal fn As String) As String

' ===============================================================
' = DirOnly()                                                   =
' =     Returns the directory part of the filename <fn>         =
' =     including last "\"                                      =
' ===============================================================
'
Declare Function DirOnly Lib "VBossAPI.DLL" (ByVal fn As String) As String

' ===============================================================
' = ReplacePath()                                               =
' =     Replaces the path in <fn> with the path in <np>         =
' ===============================================================
'
Declare Function ReplacePath Lib "VBossAPI.DLL" (ByVal fn As String, ByVal np As String) As String


' *************************
' ** END OF VBOSSAPI.BAS **
' *************************

