unit Main;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, DBNETCON, Spin;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Panel1: TPanel;
    StatusLine: TPanel;
    Panel2: TPanel;
    Window1: TMenuItem;
    Help1: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    DBNetConnect1: TDBNetConnect;
    SpeedPanel: TPanel;
    ExitBtn: TSpeedButton;
    EnableBtn: TSpeedButton;
    Demo1: TMenuItem;
    Holdings1: TMenuItem;
    Emloyees1: TMenuItem;
    BroadcastWin1: TMenuItem;
    AlertBtn: TSpeedButton;
    NCAlarm: TDBNetConnectChild;
    AlarmPanel: TPanel;
    ClearAlertBtn: TSpeedButton;
    NCClearAlarm: TDBNetConnectChild;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EnableBtnClick(Sender: TObject);
    procedure Holdings1Click(Sender: TObject);
    procedure Emloyees1Click(Sender: TObject);
    procedure AlertBtnClick(Sender: TObject);
    procedure NCAlarmUpdate(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure ClearAlertBtnClick(Sender: TObject);
    procedure NCClearAlarmUpdate(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure BroadcastWin1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
    fAlert : Boolean;
    fAlertTime : TDateTime;
    procedure ShowHint(Sender: TObject);
    procedure SetAlert(Value : Boolean);
  public
    { Public declarations }
    property Alert : Boolean read FAlert write SetAlert;
    property AlertTime : TDateTime read fAlertTime write fAlertTime;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, Childwn2, childwn3;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.Caption := Application.Hint;
end;

procedure TMainForm.SetAlert(Value : Boolean);
begin
  case Value of
    TRUE:  begin
             AlarmPanel.Color   := clRed;
             AlarmPanel.Caption := TimeToStr(AlertTime);
             ClearAlertBtn.Enabled := True;
           end;
    FALSE: begin
             AlarmPanel.Color   := clLime;
             AlarmPanel.Caption := '';
             ClearAlertBtn.Enabled := False;
           end;
  end;
end;

procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.EnableBtnClick(Sender: TObject);
begin
  DBNetConnect1.Active := not DBNetConnect1.Active;
  if EnableBtn.Down then EnableBtn.Caption := '&Disable'
                    else EnableBtn.Caption := '&Enable';
  AlertBtn.Enabled := true;
end;

procedure TMainForm.Holdings1Click(Sender: TObject);
var
  Child: TMDIHoldings;
begin
  { create a new MDI child window }
  Child := TMDIHoldings.Create(Application);
  Child.Caption := 'Holdings';
end;

procedure TMainForm.Emloyees1Click(Sender: TObject);
var
  Child: TMDIEmployee;
begin
  { create a new MDI child window }
  Child := TMDIEmployee.Create(Application);
  Child.Caption := 'Employee''s';
end;

procedure TMainForm.AlertBtnClick(Sender: TObject);
begin
  NCAlarm.SendChange;
end;

procedure TMainForm.NCAlarmUpdate(Sender: TObject; Channel: Longint;
  Stamp: TDateTime);
begin
  AlertTime := Stamp;
  Alert := True;
end;

procedure TMainForm.NCClearAlarmUpdate(Sender: TObject; Channel: Longint;
  Stamp: TDateTime);
begin
  Alert := False;
end;

procedure TMainForm.ClearAlertBtnClick(Sender: TObject);
begin
  NCClearAlarm.SendChange;
end;


procedure TMainForm.BroadcastWin1Click(Sender: TObject);
var
  Child: TMDIMultiTable;
begin
  { create a new MDI child window }
  Child := TMDIMultiTable.Create(Application);
  Child.Caption := 'Multi Table';
end;

procedure TMainForm.SpinEdit1Change(Sender: TObject);
begin
  if Spinedit1.Value < 1
    then SpinEdit1.Value := 1;
  DBNetConnect1.Scaninterval := Spinedit1.Value;
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
  if DBNetConnect1.ResetNetTable
    then ShowMessage('Netscan cleared!')
    else ShowMessage('Error by clearing! Please retry.');
end;

end.
