' =========================================================================
'
'                                  %
'      %%    %% %%%%%%            %%               %    %%%%%%  %%%%
'      %%    %%  %%  %%           %%              %%%    %%  %%  %%
'      %%    %%  %%  %%  %%%%%  %%%%%%  %% %%%   %% %%   %%  %%  %%
'      %%    %%  %%%%%  %%   %%   %%     %%% %% %%   %%  %%  %%  %% v1.10
'      %%    %%  %%  %%  %%%      %%     %%  %% %%%%%%%  %%%%%   %%
'       %%  %%   %%  %%    %%%    %%     %%     %%   %%  %%      %%
'        %%%%    %%  %% %%   %%   %% %%  %%     %%   %%  %%      %%
'         %%    %%%%%%   %%%%%     %%%  %%%%    %%   %% %%%%    %%%%
'
'       A String Buffer and Huge String Array Object Server Library
'            Written specifically for Visual Basic for Windows
'
'                     Copyright  1995, Greg Truesdell
'
' =========================================================================
Option Explicit

' =========================================================================
' = FindStringXX()                                                        =
' =     Optimizing string search function                                 =
' =                                                                       =
' = FindString()    is CASE SENSITIVE                                     =
' = FindStringIC()  is CASE INSENSITIVE                                   =
' =========================================================================
'
Declare Function FindString Lib "VBstrAPI.DLL" (ByVal Start As Integer, ByVal srcStr As String, ByVal targetStr As String) As Long
Declare Function FindStringIC Lib "VBstrAPI.DLL" (ByVal Start As Integer, ByVal srcStr As String, ByVal targetStr As String) As Long

' =========================================================================
' = CenterString()                                                        =
' =     Centers the <srcStr> string in spaces or char                     =
' =                                                                       =
' = CenterString()      centers the string in spaces                      =
' = CenterStringIn()    centers the string in characater                  =
' =========================================================================
'
Declare Function CenterString Lib "VBstrAPI.DLL" (ByVal srcStr As String, ByVal wide As Integer) As String
Declare Function CenterStringIn Lib "VBstrAPI.DLL" (ByVal srcStr As String, ByVal char As String, ByVal wide As Integer) As String

' =========================================================================
' = CopyFile()                                                            =
' =     Copies the source file to the new destination file                =
' =========================================================================
'

'   CopyFile Error Codes
    
Global Const CF_SUCCESS = 0              ' Successful
Global Const CF_SAME_ERROR = -1          ' Can't copy to same file
Global Const CF_ATTR_ERROR_SRC = -2      ' source file attribute error
Global Const CF_ATTR_ERROR_DEST = -3     ' destination file attribute error
Global Const CF_OPEN_ERROR_SRC = -4      ' source file open error
Global Const CF_OPEN_ERROR_DEST = -5     ' destination file open error
Global Const CF_READ_ERROR = -6          ' source file read error
Global Const CF_WRITE_ERROR = -7         ' destination file write error
Global Const CF_CLOSE_ERROR = -8         ' destiation file close error
Global Const CF_ATTR_ERROR = -9          ' general attribute error
Global Const CF_FILE_INVALID = -10       ' source file is invalid
Global Const CF_PATH_INVALID = -11       ' destination file is invalid

Declare Function CopyFile Lib "VBstrAPI.DLL" (ByVal srcFile As String, ByVal destFile As String) As Integer


' ====================================================================================
' =          Concatenation String Array Object Functions and Procedures              =
' ====================================================================================
' =                 See VBstrAPI.HLP for more information.                           =
' ====================================================================================
Declare Function CreateNewCatString Lib "VBstrAPI.DLL" (ByVal cbSize As Long) As Integer
Declare Sub DestroyCatString Lib "VBstrAPI.DLL" (ByVal SHandle As Integer)
Declare Function CatStrLength Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long
Declare Sub CatStrClear Lib "VBstrAPI.DLL" (ByVal SHandle As Integer)
Declare Sub CatStrResetCLP Lib "VBstrAPI.DLL" (ByVal SHandle As Integer)
Declare Function CatStrAdd Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal St As String) As Integer
Declare Function CatStrAddLine Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal St As String) As Integer
Declare Function CatStrNext Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal cbSize As Long, Status As Integer) As String
Declare Function CatStrNextLine Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, Status As Integer) As String
Declare Function CatStrCopy Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As String
Declare Function CatStrMid$ Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Start As Long, ByVal cbSize As Long)
Declare Function CatStrFind Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Start As Long, ByVal Target As String) As Long
Declare Function CatStrFindIC Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Start As Long, ByVal Target As String) As Long
Declare Sub CatStrSetCLP Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal NewCLP As Long)
Declare Function CatStrLineCount Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long
Declare Function CatStrLPSZ Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long

' ====================================================================================
' =                Huge String Array Object Functions and Procedures                 =
' ====================================================================================
' =                 See VBstrAPI.HLP for more information.                           =
' ====================================================================================
Declare Function CreateNewStringArray Lib "VBstrAPI.DLL" (ByVal cbItems As Long, ByVal cbSize As Long) As Integer
Declare Sub DestroyStringArray Lib "VBstrAPI.DLL" (ByVal SHandle As Integer)
Declare Function GetArrayStr Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long) As String
Declare Function PutArrayStr Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long, ByVal St As String) As Integer
Declare Function GetArrayNext Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As String
Declare Function PutArrayNext Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal St As String) As Integer
Declare Function DeleteArrayStr Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long) As Integer
Declare Function InsertArrayStr Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long, ByVal St As String) As Integer
Declare Function ArrayStrBufSize Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long
Declare Function ArrayStrMemSize Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long
Declare Function ArrayStrCLP Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long
Declare Sub ArrayStrClear Lib "VBstrAPI.DLL" (ByVal SHandle As Integer)
Declare Function ArrayStrElements Lib "VBstrAPI.DLL" (ByVal SHandle As Integer) As Long
Declare Sub ArrayStrSetCLP Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long)
Declare Function PutArrayBlk Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long, Block As Any, ByVal cbSize As Long) As Integer
Declare Sub GetArrayBlk Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal Element As Long, Block As Any, ByVal cbSize As Long)
' new for release 1.40
Declare Function ArrayStrResize Lib "VBstrAPI.DLL" (ByVal SHandle As Integer, ByVal NewSize As Long) As Long

