VERSION 2.00
Begin Form OSSMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "VBossAPI Script Processing Example Application"
   ClientHeight    =   2490
   ClientLeft      =   165
   ClientTop       =   2010
   ClientWidth     =   8190
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   2865
   Icon            =   OSSMAIN.FRX:0000
   Left            =   120
   LinkTopic       =   "Form1"
   ScaleHeight     =   2490
   ScaleWidth      =   8190
   Top             =   1680
   Width           =   8280
   Begin PictureBox PassOne 
      AutoSize        =   -1  'True
      Height          =   510
      Left            =   4440
      Picture         =   OSSMAIN.FRX:0302
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   11
      Top             =   1710
      Visible         =   0   'False
      Width           =   510
   End
   Begin PictureBox RunOff 
      AutoSize        =   -1  'True
      Height          =   510
      Left            =   5820
      Picture         =   OSSMAIN.FRX:0604
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   9
      Top             =   1710
      Visible         =   0   'False
      Width           =   510
   End
   Begin PictureBox RunOn 
      AutoSize        =   -1  'True
      Height          =   510
      Left            =   5160
      Picture         =   OSSMAIN.FRX:0906
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   8
      Top             =   1710
      Visible         =   0   'False
      Width           =   510
   End
   Begin SSCommand biAbout 
      Font3D          =   3  'Inset w/light shading
      Height          =   900
      Left            =   7380
      Picture         =   OSSMAIN.FRX:0C08
      RoundedCorners  =   0   'False
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   15
      Width           =   825
   End
   Begin SSCommand tbOption 
      Caption         =   "&Save"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   900
      Index           =   2
      Left            =   2400
      Picture         =   OSSMAIN.FRX:0F0A
      RoundedCorners  =   0   'False
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   15
      Width           =   930
   End
   Begin SSCommand tbOption 
      Caption         =   "&Load"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   900
      Index           =   1
      Left            =   1620
      Picture         =   OSSMAIN.FRX:120C
      RoundedCorners  =   0   'False
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   15
      Width           =   800
   End
   Begin SSCommand tbOption 
      Caption         =   "&RUN"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   900
      Index           =   0
      Left            =   780
      Picture         =   OSSMAIN.FRX:150E
      RoundedCorners  =   0   'False
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   15
      Width           =   860
   End
   Begin SSCommand biQuit 
      Caption         =   "&Exit"
      Font3D          =   3  'Inset w/light shading
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   900
      Left            =   0
      Picture         =   OSSMAIN.FRX:1810
      RoundedCorners  =   0   'False
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   15
      Width           =   800
   End
   Begin CommonDialog CD 
      Left            =   5760
      Top             =   990
   End
   Begin ListBox Monitor 
      BackColor       =   &H00008000&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   6.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   3510
      TabIndex        =   2
      TabStop         =   0   'False
      Tag             =   "OL"
      Top             =   1020
      Width           =   1605
   End
   Begin TextBox Editor 
      BackColor       =   &H00C0C0C0&
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   855
      Left            =   60
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      TabStop         =   0   'False
      Tag             =   "OL"
      Top             =   1020
      Width           =   3375
   End
   Begin PictureBox ToolBar 
      BackColor       =   &H00808000&
      Height          =   915
      Left            =   30
      ScaleHeight     =   885
      ScaleWidth      =   8145
      TabIndex        =   0
      TabStop         =   0   'False
      Tag             =   "OL"
      Top             =   0
      Width           =   8175
      Begin SSCommand tbOption 
         Caption         =   "Keywords"
         Font3D          =   3  'Inset w/light shading
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   900
         Index           =   3
         Left            =   6420
         Picture         =   OSSMAIN.FRX:1B12
         RoundedCorners  =   0   'False
         TabIndex        =   10
         TabStop         =   0   'False
         Top             =   0
         Width           =   915
      End
   End
End
Option Explicit

'
' Tool Bar command indexes
'
Const TB_START = 0      ' start program
Const TB_LOAD = 1       ' load program
Const TB_SAVE = 2       ' save program
Const TB_KEYS = 3       ' display keywords

Dim EditorChanged As Integer
Dim MyScript As Integer

Sub biAbout_Click ()
    
    AboutBox.Show 1
    Editor.SetFocus

End Sub

Sub biQuit_Click ()

    Unload Me

End Sub

Sub Editor_Change ()

    EditorChanged = True

End Sub

Sub Form_Activate ()
Dim rc As Integer
Static once As Integer

    If Not once Then
        
        rc = SendMessage(Editor.hWnd, EM_SETTABSTOPS, 1, 16&)
        once = True
    
    End If

End Sub

Sub Form_Load ()
Dim rc As Integer

    ChDir App.Path

    Me.Height = Screen.Height - 240
    Me.Width = Screen.Width - 240
    CenterForm Me, 0, 0

    Me.Show
    Editor.SetFocus
    
    DoEvents

    '
    ' THIS STEP IS NOW REQUIRED - CREATES A NEW INSTANCE
    ' SEE UNLOAD EVENT FOR LAST STEP
    '
    MyScript = CreateScrObject()
    
    '
    '  Enter your UserID and RegistrationKey here to disable
    '  the shareware panels.
    '
    rc = RegisterVBossAPI("User-ID", "Registration-Key")
    
    SetDefaultKeywords
    EditorChanged = False

End Sub

Sub Form_Paint ()

    Outlines Me

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
Const ID_YES = 6
Const ID_CANCEL = 2
Dim rc As Integer

    If EditorChanged Then

        rc = MsgBox("Program changed, Save before Exit?", MB_YESNOCANCEL + MB_ICONQUESTION, "Program Changed")

        If rc = ID_CANCEL Then
            
            Cancel = True
            Editor.SetFocus

        ElseIf rc = ID_YES Then

            SaveFile Editor

        End If

    End If

End Sub

Sub Form_Resize ()

Dim WorkTop     As Integer
Dim WorkLeft    As Integer
Dim WorkRight   As Integer
Dim WorkBottom  As Integer
    
    On Error Resume Next

    WorkTop = ToolBar.ScaleHeight + 240
    WorkLeft = 120
    WorkRight = ScaleWidth - 120
    WorkBottom = ScaleHeight - (WorkTop + 120)

    Editor.Left = WorkLeft
    Editor.Height = WorkBottom
    Editor.Top = WorkTop
    Editor.Width = WorkLeft + (WorkRight * .6)

    Monitor.Top = WorkTop
    Monitor.Height = WorkBottom
    Monitor.Left = (WorkLeft * 2) + Editor.Width
    Monitor.Width = WorkRight - Monitor.Left

End Sub

Sub Form_Unload (Cancel As Integer)

    DestroyScrObject MyScript

End Sub

'
' PROCEDURE OpenFile <textbox>
'
'   Using the Common Dialog DLL, prompt for and open a program
'   located in the TextBox control passed as <program>
'
Sub ReadFile (program As TextBox)

Dim RF_TITLE As String   ' dialog title
Dim file        As Integer          ' file I/O handle
Dim Filename    As String           ' filename
Dim buf         As String           ' the program buffer

    On Error GoTo RF_Cancel

    file = FreeFile

    RF_TITLE = "Load Program"
    cd.CancelError = True
    cd.DefaultExt = "prg"
    cd.DialogTitle = RF_TITLE
    cd.Filter = "Source (*.prg)|*.prg|Text (*.txt)|*.txt|Any (*.*)|*.*"
    cd.InitDir = App.Path
    cd.Flags = CDF_OPEN

    cd.Action = CD_OPEN
    Filename = cd.Filename
    
    buf = Space(FileLen(Filename))
    Open Filename For Binary Access Read As file

    Get file, , buf
    Close file

    program.Text = buf
    buf = ""

    EditorChanged = False

' [Exit Sub]

GoTo RF_Exit

RF_Cancel:

    If Not (Err = CDERR_CANCEL) Then
        
        MsgBox "Cancelled. An error has ocurred!" & CRLF & "[" & Err & "]" & Error$, MB_ICONSTOP, RF_TITLE

    End If
    
    Resume RF_Exit

RF_Exit:


End Sub

'
' PROCEDURE SaveFile <textbox>
'
'   Using the Common Dialog DLL, prompt for and save program
'   located in the TextBox control passed as <program>
'
Sub SaveFile (program As TextBox)

Dim SF_TITLE As String   ' dialog title
Dim file        As Integer          ' file I/O handle
Dim Filename    As String           ' filename
Dim buf         As String           ' the program buffer

    On Error GoTo SF_Cancel

    file = FreeFile
    buf = Trim$(program.Text)

    SF_TITLE = "Save Program As"
    cd.CancelError = True
    cd.DefaultExt = "prg"
    cd.DialogTitle = SF_TITLE
    cd.Filter = "Source (*.prg)|*.prg|Text (*.txt)|*.txt|Any (*.*)|*.*"
    cd.InitDir = App.Path
    cd.Flags = CDF_SAVE

    cd.Action = CD_SAVEAS
    Filename = cd.Filename
    
    On Error Resume Next
    Kill Filename
    On Error GoTo SF_Cancel

    Open Filename For Binary Access Write As file
    Put file, , buf
    Close file

    EditorChanged = False

' [Exit Sub]

GoTo SF_Exit

SF_Cancel:

    If Err = CDERR_CANCEL Then
        
        MsgBox "Cancelled. Program not saved.", MB_OK + MB_ICONEXCLAMATION, SF_TITLE

    Else

        MsgBox "Cancelled. An error has ocurred!" & CRLF & " [" & Err & "] " & Error$, MB_ICONSTOP, SF_TITLE

    End If
    
    Resume SF_Exit

SF_Exit:  End Sub

'
' ToolBar option buttons
'
Sub tbOption_Click (Index As Integer)

  Dim rc As Integer
    
    Select Case Index

        '
        '  Run
        '
        Case TB_START

            tbOption(TB_START).Picture = OSSMain.PassOne
            DoEvents

            '
            ' initialize variables for first pass (Label search)
            '
            ixLabel = 0
            ReDim Labels(24)
            ZapVariables
            
            FirstPass = True
            
            If Interpret(Editor) Then

                '
                ' no glaring syntax errors, so preset the labels
                '
                PresetLabels
                ReturnStack(0) = 0
                UntilStack(0) = 0
                NextStack(0) = 0

                tbOption(TB_START).Picture = OSSMain.RunOn

                '
                '  Now execute the script
                '
                FirstPass = False       ' second pass
                rc = Interpret(Editor)

            End If
        
            tbOption(TB_START).Picture = OSSMain.RunOff
        
        Case TB_LOAD

            ReadFile Editor

        Case TB_SAVE

            SaveFile Editor

        Case TB_KEYS

            KeyForm.Show 1

    End Select

    Editor.SetFocus

End Sub

