unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls;

type
  TfrmMain = class(TForm)
    dfAlias: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    dfInputFile: TEdit;
    Label3: TLabel;
    dfOutputFile: TEdit;
    btnStart: TButton;
    dbMain: TDatabase;
    qLoad: TQuery;
    Button1: TButton;
    procedure btnStartClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  procedure procLoadData;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnStartClick(Sender: TObject);
begin
  dbMain.Connected:=False;
  dbMain.ALIASName:=dfAlias.Text;
  Screen.Cursor:=crHourglass;
  try
    dbMain.Connected:=True;
    messagedlg('Successful connection', mtInformation, [mbOK],0);
    procLoadData;
  except
    on E: EDatabaseError do
      begin
      messagedlg('Connection Failed',mtError, [mbOK],0);
      screen.Cursor:=crDefault;
      end;
  end;

end;

procedure procLoadData;
   function fnStripSQL(strSQL: String):String;
   var
      strTemp: String;
      strOut: String;
      nIndex: Integer;
   begin
      nIndex:=1;
      strOut:='';
      while nIndex<Length(strSQL) do
        begin
          strTemp:='';
          strTemp:=Copy(strSQL, nIndex, 1);
          if not((strTemp=#10) or (strTemp=#13)) then
             strOut:=strOut+strTemp;
          nIndex:=nIndex+1;
        end;
      fnStripSQL:=strOut;
   end;

var
   nFileIn, nFileOut: TextFile;
   bLoop: Boolean;
   strSQL: String;
begin
   screen.cursor:=crHourglass;
   {Open the files for read/write}
   AssignFile(nFileIn, frmMain.dfInputFile.Text);
   AssignFile(nFileOut, frmMain.dfOutputFile.Text);
   Rewrite(nFileOut);
   Reset(nFileIn);

   While not EOF(nFileIn) do
     begin
     {Read nFileIn into the Query SQL String list until we hit a ';'}
     frmMain.qLoad.Close;
     frmMain.qLoad.SQL.Clear;
     bLoop:=False;
     While bLoop=False do
       begin
       ReadLn(nfileIn, strSQL);
       {strSQL:=fnStripSQL(strSQL);}
       WriteLn(nFileOut, strSQL);
       {If the last character is a ';' then stop reading}
       if pos(';', strSQL)<>0 then
          begin
          bLoop:=True;
          frmMain.qLoad.SQL.Add(strSQL);
          end;
       if strSQL='' then bLoop:=True;

       end;
     try
       WriteLn(nFileOut, 'Executing.........');
       frmMain.qLoad.ExecSQL;
     except
       on E: EDatabaseError do
          begin
          WriteLn(nfileOut, 'FAILED - '+ E.Message);
          end;
     end;

     end;

   closefile(nFileIn);
   CloseFile(nFileOut);
   screen.cursor:=crDefault;
   messagedlg('DONE', mtInformation, [mbOK],0);

end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  Close;
end;

end.
