' Shade.Bas - Shading Subroutines
' 94/09/28 Created this date by Larry Rebich, The Bridge, Inc, 71662,205

    Option Explicit
    DefInt A-Z

    Global Const Inside_Solid = 6
    Global Const Copy_Pen = 13
    Global Const Pixels = 3

Sub DoName (TheForm As Form, TheName As String)
    Dim x, y                        'print here
    TheForm.ZOrder 0                'needed to print over drawn colors
    TheForm.ForeColor = RGB(32, 32, 32) 'very dark gray
    TheForm.FontName = "Arial"      'the font
    TheForm.FontSize = 48           'some nice large size
    x = 200                         'x offset, start printing here
    y = 100                         'y offset
    TheForm.CurrentX = x            'set cursor!
    TheForm.CurrentY = y
    TheForm.Print TheName;          'print it

    TheForm.ForeColor = RGB(255, 255, 255)  'white
    TheForm.CurrentX = x - 35       'give us an upper left highlight color
    TheForm.CurrentY = y - 45
    TheForm.Print TheName;          'print white
    
    TheForm.ForeColor = &HFFFF&     'nice yellow
    TheForm.CurrentX = x - 25       'back up a little for over the left shoulder light source
    TheForm.CurrentY = y - 35
    TheForm.Print TheName;          'print now in nice yellow
End Sub

Sub DoShade (TheForm As Form)
    Dim ds, dm, dw, sm, sh          'save these settings
    Dim i As Integer                'for next loop
    ds = TheForm.DrawStyle                  'save 'em
    dm = TheForm.DrawMode
    dw = TheForm.DrawWidth
    sm = TheForm.ScaleMode
    sh = TheForm.ScaleHeight
    TheForm.DrawStyle = Inside_Solid        'use this style
    TheForm.DrawMode = Copy_Pen             'this mode
    TheForm.DrawWidth = 2                   'required for dithering
    TheForm.ScaleMode = Pixels              'mode
    TheForm.ScaleHeight = 256               'height set to this many color scale
    For i = 0 To 255                'now do it
        TheForm.Line (0, i)-(TheForm.Width, i + 1), RGB(0, 0, 255 - i), B    'blue
    Next
    TheForm.DrawStyle = ds          'restore the settings
    TheForm.DrawMode = dm
    TheForm.DrawWidth = dw
    TheForm.ScaleHeight = sh        'must be restored before ScaleMode
    TheForm.ScaleMode = sm
End Sub

