' User Profile Routines
' NOTE: The lpKeyName argument for GetProfileString, WriteProfileString,
'       GetPrivateProfileString, and WritePrivateProfileString can be either
'       a string or NULL.  This is why the argument is defined as "By Any".
'          For example, to pass a string specify   ByVal "wallpaper"
'          To pass NULL specify                    ByVal 0&
'       You can also pass NULL for the lpString argument for WriteProfileString
'       and WritePrivateProfileString

Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, lpString As Any, ByVal lplFileName As String) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Function GetINIInt (FileName As String, Application As String, Parameter As String) As Integer
        
        If InStr(1, FileName, "\") = 0 Then
        If FileName = "" Then
                FileName = WinDir() + "WIN.INI"
        Else
                FileName = WinDir() + FileName
        End If
    End If
    GetINIInt = GetPrivateProfileInt(Application, Parameter, 0, FileName)    ' Make API Call
End Function

Function GetINIString (FileName As String, Application As String, Parameter As String) As String
    temp$ = String$(255, 0)                 ' Size Buffer
    If InStr(1, FileName, "\") = 0 Then
        If FileName = "" Then
                FileName = WinDir() + "WIN.INI"
        Else
                FileName = WinDir() + FileName
        End If
    End If
    x = GetPrivateProfileString(Application$, ByVal Parameter$, "", temp$, 255, FileName$)   ' Make API Call
    temp$ = Left$(temp$, x)                 ' Trim Buffer
    GetINIString$ = temp$
End Function

Function GetProgExt () As String
    Value$ = GetINIString("WIN.INI", "Windows", "Programs")
    Res% = 0
    Do While True
        Res1% = InStr(Res% + 1, Value$, " ")
        If Res1% = 0 And Len(Value$) = 0 Then
            Exit Do
        Else
            If Res1% > 0 Then
                tVal$ = Mid(Value$, Res% + 1, Res1% - (Res% + 1))
            Else
                tVal$ = Mid(Value$, Res% + 1, Len(Value$) - (Res%))
                Value$ = ""
            End If
            If Len(ProgTemp$) > 0 Then
                ProgTemp$ = ProgTemp$ + ";"
            End If
            ProgTemp$ = ProgTemp$ + "*." + tVal$
        End If
        Res% = Res1%
        Loop
    GetProgExt$ = ProgTemp$
    
End Function

Function SysDir () As String
    temp$ = String$(145, 0)                 ' Size Buffer
    x = GetSystemDirectory(temp$, 145)      ' Make API Call
    temp$ = Left$(temp$, x)                 ' Trim Buffer

    If Right$(temp$, 1) <> "\" Then         ' Add \ if necessary
        SysDir$ = temp$ + "\"
    Else
        SysDir$ = temp$
    End If
End Function

Function WinDir () As String
    temp$ = String$(145, 0)              ' Size Buffer
    x = GetWindowsDirectory(temp$, 145)  ' Make API Call
    temp$ = Left$(temp$, x)              ' Trim Buffer

    If Right$(temp$, 1) <> "\" Then      ' Add \ if necessary
        WinDir$ = temp$ + "\"
    Else
        WinDir$ = temp$
    End If
End Function

Function WriteINI (FileName As String, Application As String, Parameter As String, Value As String) As Integer
    If InStr(1, FileName, "\") = 0 Then
        If FileName = "" Then
            FileName = WinDir() + "WIN.INI"
        Else
            FileName = WinDir() + FileName
        End If
    End If
    If Value = "" Then
        WriteINI = WritePrivateProfileString(Application$, ByVal Parameter$, ByVal 0&, FileName$)
    Else
        WriteINI = WritePrivateProfileString(Application$, ByVal Parameter$, ByVal Value$, FileName$)
    End If
End Function

