VERSION 2.00
Begin Form Form1 
   Caption         =   "Test of WNet Functions"
   ClientHeight    =   4020
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   7365
   Height          =   4425
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   4020
   ScaleWidth      =   7365
   Top             =   1140
   Width           =   7485
   Begin CommandButton disconnect 
      Caption         =   "Disconnect"
      Height          =   495
      Left            =   3120
      TabIndex        =   7
      Top             =   3360
      Width           =   1215
   End
   Begin CommandButton Connect 
      Caption         =   "Connect..."
      Height          =   495
      Left            =   480
      TabIndex        =   6
      Top             =   3360
      Width           =   1215
   End
   Begin ListBox List1 
      Height          =   1785
      Left            =   120
      TabIndex        =   4
      Top             =   1080
      Width           =   7215
   End
   Begin CommandButton Command1 
      Caption         =   "Ok"
      Height          =   495
      Left            =   5880
      TabIndex        =   3
      Top             =   3360
      Width           =   1215
   End
   Begin Label Label5 
      Caption         =   "WNetCancelConnection"
      Height          =   255
      Left            =   2640
      TabIndex        =   9
      Top             =   3000
      Width           =   2415
   End
   Begin Label Label4 
      Caption         =   "WNetAddConnection"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   3000
      Width           =   2415
   End
   Begin Label Label3 
      Caption         =   "WNetGetConnection"
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   5
      Top             =   840
      Width           =   1935
   End
   Begin Label Label3 
      Caption         =   "WNetGetUser"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1335
   End
   Begin Label Label2 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Label2"
      Height          =   255
      Left            =   5280
      TabIndex        =   1
      Top             =   480
      Width           =   2055
   End
   Begin Label Label1 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Label1"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   480
      Width           =   5055
   End
End
Option Explicit
' This is a demonstration program to use the common
' WNET... routines for Windows Network support
' Author: K. True, Intel Corp., 1993

Declare Function WNetGetUser% Lib "USER" (ByVal szUser As String, iBufSize As Integer)
Declare Function WnetAddConnection% Lib "user" (ByVal lpszNetPath As Any, ByVal lpszPassword As Any, ByVal lpszLocalName As Any)
Declare Function GetDriveType% Lib "kernel" (ByVal nDrive%)
Declare Function WNetGetConnection% Lib "user" (ByVal lpszLocalName As String, ByVal lpszRmtName As String, iRmtLen As Integer)
Declare Function WNetCancelConnection% Lib "user" (ByVal lpszLocalName As String, ByVal iForce As Integer)
Declare Function WNetBrowseDialog% Lib "user" (ByVal hWParent As Integer, ByVal iType As Integer, ByVal lpszPath As String)


' WNet constants
Const WN_Success = &H0
Const WN_Not_Supported = &H1
Const WN_Net_Error = &H2
Const WN_More_Data = &H3
Const WN_Bad_Pointer = &H4
Const WN_Bad_Value = &H5
Const WN_Bad_Password = &H6
Const WN_Access_Denied = &H7
Const WN_Function_Busy = &H8
Const WN_Bad_User = &HA
Const Wn_Out_Of_Memory = &HB
Const WN_Cancelled = &HC
Const WN_Not_Connected = &H30
Const WN_Open_Files = &H31
Const WN_Bad_NetName = &H32
Const WN_Bad_Localname = &H33
Const WN_Already_Connected = &H34
Const WN_Bad_JobID = &H40
Const WN_Job_Not_Found = &H41
Const WN_Job_Not_Held = &H42
Const WN_Bad_Queue = &H43
Const WN_Bad_Handle = &H44
Const WN_Cant_Set_Copies = &H45
Const WN_Already_Locked = &H46
Const WN_No_Error = &H50
Const WNBD_Conn_Disktree = 1
Const WNBD_Conn_PrintQ = 3
Const WNBD_CONN_SelAll = 0

'GetDriveType constants
Const Drive_Unknown = 0
Const Drive_Removable = 2
Const Drive_Fixed = 3
Const Drive_Remote = 4

Dim LF As String

Sub Command1_Click ()
   Unload Form1
End Sub

Sub Connect_Click ()
Dim iListIndx As Integer
Dim szName As String
Dim szLocal As String
Dim iPos As Integer
Dim szRmtName As String
Dim iRmtLen As Integer
Dim iRC As Integer, iRC1 As Integer
Dim szPriorName As String


  iListIndx = List1.ListIndex
  If iListIndx < 0 Then Exit Sub

  szName = TrimNullStr$(List1.List(iListIndx))
  iPos = InStr(szName, " ")   ' parse at blank to get device
  If iPos = 0 Then iPos = Len(szName) + 1
  szLocal = Mid$(szName, 1, iPos - 1)

  szRmtName = String$(255, 0)
  iRmtLen = Len(szRmtName)
  szPriorName = ""
  iRC = WNetGetConnection(szLocal, szRmtName, iRmtLen)
  Select Case iRC
    Case WN_Success
      szPriorName = szRmtName ' save old connected name
      iRC1 = WNetCancelConnection(szLocal, 0)
      If iRC1 = WN_Success Then
	List1.List(iListIndx) = szLocal
       Else
	MsgBox "Unable to disconnect. RC=" & iRC1 & LF & WNErrText(iRC1), 0, "Disconnect Error"
      End If
    Case WN_Not_Connected
      ' do nothing..
    Case Else
      MsgBox "WNetCancelConnection returns rc=" & iRC & LF & WNErrText(iRC), 0, "Disconnect Error"
  End Select

  If InStr(szLocal, "LPT") > 0 Then ' Do Printer Browse
    iRC = WNetBrowseDialog(Form1.hWnd, WNBD_Conn_PrintQ, szRmtName)
   Else
    iRC = WNetBrowseDialog(Form1.hWnd, WNBD_Conn_Disktree, szRmtName)
  End If

  If iRC = WN_Success Then
    iRC = WnetAddConnection(szRmtName, "", szLocal)
    If iRC = WN_Success Then
      List1.List(iListIndx) = szLocal & "  " & TrimNullStr$(szRmtName)
    Else
      MsgBox "WnetAddConnection RC=" & iRC & LF & WNErrText(iRC), 0, "Connect Error:"
    End If
   Else
    If Len(szPriorName) > 0 Then ' reset to prior state
      iRC = WnetAddConnection(szPriorName, "", szLocal)
      If iRC = WN_Success Then
	List1.List(iListIndx) = szLocal & "  " & TrimNullStr$(szRmtName)
      Else
	MsgBox "WnetAddConnection RC=" & iRC & LF & WNErrText(iRC), 0, "Connect Error:"
      End If
    End If
  End If

End Sub

Sub disconnect_Click ()

Dim iListIndx As Integer
Dim szName As String
Dim szLocal As String
Dim iPos As Integer
Dim szRmtName As String
Dim iRmtLen As Integer
Dim iRC As Integer, iRC1 As Integer


  iListIndx = List1.ListIndex
  If iListIndx < 0 Then Exit Sub

  szName = TrimNullStr$(List1.List(iListIndx))
  iPos = InStr(szName, " ")   ' parse at blank to get device
  If iPos = 0 Then iPos = Len(szName) + 1
  szLocal = Mid$(szName, 1, iPos - 1)

  szRmtName = String$(255, 0)
  iRmtLen = Len(szRmtName)
  iRC = WNetGetConnection(szLocal, szRmtName, iRmtLen)
  Select Case iRC
    Case WN_Success
      iRC1 = WNetCancelConnection(szLocal, 0)
      If iRC1 = WN_Success Then
	List1.List(iListIndx) = szLocal
       Else
	MsgBox "Unable to disconnect. RC=" & iRC1 & LF & WNErrText(iRC1), 0, "Disconnect Error"
      End If
    Case WN_Not_Connected
      ' do nothing..
    Case Else
      MsgBox "WNetCancelConnection returns rc=" & iRC & LF & WNErrText(iRC), 0, "Disconnect Error"
  End Select
End Sub

Sub Form_Load ()
Dim iRC As Integer
Dim szUserName As String
Dim iSize%

 LF = String$(1, 10)' a nice LineFeed character

'WNetGetUser -- retrieve user name
  szUserName = String$(255, 0)
  iSize = Len(szUserName)
  iRC = WNetGetUser%(szUserName, iSize)
  Label2.Caption = "RC = " & iRC & " iSize=" & iSize
  Label1.Caption = szUserName

'WNetGetConnection -- show current LPT/Disk connections
 LoadListBox
End Sub

   Function IsSuccess% (ReturnCode%, Msg$)



   If ReturnCode% = WN_Success Then
      IsSuccess% = True
   Else
      IsSuccess% = False
      Select Case ReturnCode%



	 Case WN_Success:
	    'Drive1.Refresh
	 Case WN_Not_Supported:
	    Msg$ = "Function is not supported."
	 Case Wn_Out_Of_Memory:
	    Msg$ = "Out of Memory."
	 Case WN_Net_Error:
	    Msg$ = "An error occurred on the network."
	 Case WN_Bad_Pointer:
	    Msg$ = "The Pointer was Invalid."
	 Case WN_Bad_NetName:
	    Msg$ = "Invalid Network Resource Name."
	 Case WN_Bad_Password:
	    Msg$ = "The Password was Invalid."
	 Case WN_Bad_Localname:
	    Msg$ = "The local device name was invalid."
	 Case WN_Access_Denied:
	    Msg$ = "A security violation occurred."
	 Case WN_Already_Connected:
	    Msg$ = "The local device was connected to a remote resource."
	 Case Else:
	    Msg$ = "Unrecognized Error " + Str$(ReturnCode%) + "."



      End Select
   End If



   End Function

Sub LoadListBox ()

Dim iRC As Integer
Dim Msg As String

Dim i As Integer
Dim szRmtName As String
Dim iRmtLen As Integer

Dim iType As Integer

'WNetGetConnection -- show current LPT/Disk connections
  
  For i = 1 To 3
    szRmtName = String(255, 0)
    iRmtLen = Len(szRmtName)
    Msg = "LPT" & i
    iRC = WNetGetConnection(Msg, szRmtName, iRmtLen)

    Msg = Msg & ": "
    Select Case iRC
       Case WN_Success
	 Msg = Msg & Mid$(szRmtName, 1, iRmtLen)
       Case WN_Not_Connected
	 Msg = Msg & "Local Device"
       Case Else
	 Msg = Msg & " (rc=" & iRC & ") " & " " & WNErrText(iRC)
    End Select

    List1.AddItem Msg
  Next i

' Do drives
  For i = 0 To 25
    iType = GetDriveType(i)   ' 0=A, 1=B...

    Msg = Chr$(i + 65) & ":  "

    Select Case iType
      Case 0
	 Msg = Msg & " "
      Case Drive_Removable
	 Msg = Msg & " (floppy drive)"
      Case Drive_Fixed
	 Msg = Msg & " (local hard disk)"
      Case Drive_Remote
	szRmtName = String(255, 0)
	iRmtLen = Len(szRmtName)
	iRC = WNetGetConnection(Chr$(i + 65) & ":", szRmtName, iRmtLen)
	Select Case iRC
	   Case WN_Success
	     Msg = Msg & Mid$(szRmtName, 1, iRmtLen)
	   Case WN_Not_Connected
	     Msg = Msg & "Not Connected"
	   Case Else
	     Msg = Msg & " (rc=" & iRC & ") " & " " & WNErrText(iRC)
	End Select
	Case Else
	  Msg = Msg & " (GetDriveType=" & iRC & ") " & " " & WNErrText(iRC)
      End Select

    List1.AddItem Msg
  Next i

End Sub

Function TrimNullStr$ (ByVal given As Variant)
    Dim i As Integer
    i = InStr(given, Chr$(0))
    If i > 0 Then
      TrimNullStr$ = Trim$(Left$(given, i - 1))
    Else
      TrimNullStr$ = Trim$(given)
    End If
End Function

Function WNErrText (iRC As Integer) As String
Dim Msg$
  
  Msg$ = ""
  Select Case iRC
	 Case WN_Success:
	    'Drive1.Refresh
	 Case WN_Not_Supported:
	    Msg$ = "Function is not supported."
	 Case WN_More_Data
	    Msg$ = "Buffer too small to hold data."
	 Case Wn_Out_Of_Memory:
	    Msg$ = "Out of Memory."
	 Case WN_Net_Error:
	    Msg$ = "An error occurred on the network."
	 Case WN_Bad_Pointer:
	    Msg$ = "The Pointer was Invalid."
	 Case WN_Bad_NetName:
	    Msg$ = "Invalid Network Resource Name."
	 Case WN_Bad_Password:
	    Msg$ = "The Password was Invalid."
	 Case WN_Bad_Localname:
	    Msg$ = "The local device name was invalid."
	 Case WN_Access_Denied:
	    Msg$ = "A security violation occurred."
	 Case WN_Already_Connected:
	    Msg$ = "The local device was connected to a remote resource."
	 
	 Case Else:
	    Msg$ = "WNET error " + Str$(iRC) + "."
 
      End Select

   WNErrText = Msg$

End Function

