{ printer.pas -- Printer support unit with Abort dialog
  Thanks to Tom Swan who put me on the right track in the first place
  and whose uAbort.pas file was the Start point for this to which I
  added various other bits and pieces gleaned from my frantic search
  to get a program to print properly!

  Also thanks to Peter Davis for an article in Windows Programming Journal
  (he said abort dialog is mandatory, too true,) and to Kurt (Teamb).

  1994 Ashley Kitson - Great Britain  Compuserve 100115,160

  You may use this code freely without fear of charge from me. If you make
  any enhancements why not post it back to BPROGA so the rest of us can use it.  

  My original requirement was to be able to send a simple text file to the
  printer.  This unit accomplishes this by a call to PrFile.  Minimal
  control of printing is used and no facilities are presented here for
  graphics printing, however as you can access the printer device context
  via the ghDC variable then this shouldn't be a difficulty.

  The unit uses the windows v3.0 escape calls which work under V3.1.  These
  could be replaced with the 3.1 procedures if you need to. Please note
  that you should use the PrGetDefaults call if you wish to guarantee
  compatibility with V3.0.  Use of the common dialog print construct is
  only (I think!) supported for v3.1 so PrGetCommDlg will fail under 3.0   

}

unit Printer;

{$R printer.res}   {abort dialog, seems to fail if you use bordlg class}
{$I standard.inc}  {my standard compiler directives}

(*******************************************************************)
                           interface
(*******************************************************************)


uses WinTypes, WinProcs, WObjects, Strings, bwcc, commdlg;

Type
  {PrAbort dialog window}
  pAbort = ^tAbort;
  tAbort = object(tDlgWindow)
    procedure WMInitDialog(var Msg: tMessage);
      virtual wm_First + wm_InitDialog;
    procedure WMCommand(var Msg: tMessage);
      virtual wm_First + wm_Command;
  end;

Var
{global variable names are prefixed g to denote global.
 The next letter denotes the type,
   b = boolean
   p = pointer
   r = record
   i = integer
   etc.
}
    ghDc         : hDc;          {handle to printer device context}
    gbPrinting   : Boolean;      {True after successful call to PrStart }
    gpAbortDiag  : pAbort;       {Pointer to Abort dialog object }
    gpAbortProc  : tFarProc;     {Pointer to Abort callback function }
    grTM         : tTextMetric;  {Text characteristics record}
    giEscResult  : Integer;      {result of last printer escape sequence}
    giPgWidth,                   {width of page}
    giPgHeight,                  {height of page}
    giLnHeight,                  {height of single line}
    giLnPerPage,                 {how many lines on page}
    giCurrLine   : integer;      {current line number}

Const
{global constants take same name format as variables except they are
  gc..
}
    gcpcAbortID = 'AbortDiag';    {Dialog resource ID }
    {reset the following constants before any function calls if you
     need to change them.}
    gciLinesAtTop : integer = 3;  {number of lines at top of page}
    gciLinesAtBot : integer = 3;  {number of lines at bottom of page}
    gciLMargin    : integer = 10; {left margin number of characters (avg.)}

    function PrGetDefaults(var DeviceName:pchar; {get default printer}
                           var DriverName:pchar; { from win.ini}
                           var OutputName:pchar): Boolean;
    function PrGetCommDlg(var DeviceName:pchar;  {get user choice of printer}
                          var DriverName:pchar;  {  via common dialog box}
                          var OutputName:pchar): Boolean;
    function PrStart(DocName,          {doc name for print manager}
                     DeviceName,       {printer device name}
                     Drivername,       {printer driver name}
                     OutPutName: PChar): {output file name}
                      Boolean;  {Start up printer}
    function PrStop:boolean;                    {Stop the printer}
    function PrLine(Line : pChar):boolean;      {print a line}
    function PrNewPage:boolean;                 {Start a new page}
    function PrAbort:boolean;                   {force Abort of Printing
                                                 *** NOT IMPLEMENTED ***}
    function PrFile(FileName : pchar;  {print a text file}
                    Dlg:Boolean          {true if user should choose}
                    ):                   {  printer from dialog box}
                    boolean;

(*******************************************************************)
                          implementation
(*******************************************************************)

var

    bAborted        : Bool;      {True if Cancel button selected }
    hAbortDiag     : HWnd;      {Handle to modeless PrAbort dialog }


(********************* PrAbort callback function ******************)

function AbortProc(PDc: HDC; Code: Integer): Bool; export;
var
  Msg: TMsg;
begin
  while (not bAborted) and PeekMessage(Msg, 0, 0, 0, pm_Remove) do
    if (hAbortDiag = 0) or not IsDialogMessage(hAbortDiag, Msg) then
    begin
      TranslateMessage(Msg);
      DispatchMessage(Msg)
    end;
  AbortProc := not bAborted
end;

(************************* utility functions ***************************)
function Strtok(p:pchar;c:char):pchar; {does the same job as c equivelent}
const
  Next : pchar = nil;
begin
  if p = nil then p := next;
  next := strScan(p,c);
  if next <> nil then begin
    next^ := #0;
    next := @next[1];
  end;
  StrTok := P;
end;

(************************* Printer functions ***************************)

{get the default printer from Win.ini}
function PrGetDefaults(var DeviceName:pchar;
                       var DriverName:pchar;
                       var OutputName:pchar): Boolean;
Var
  Buffer : array[0..255] of char;
  Temp   : pchar;
begin
  GetProfileString('windows','device',',,',buffer,sizeof(buffer));
  if strComp(Buffer,',,')=0 then
    PrGetDefaults := false
   else begin
    temp := StrTok(Buffer,',');
    if DeviceName = nil then getmem(devicename,strlen(temp)+1);
    strcopy(DeviceName,temp);
    temp := StrTok(nil,',');
    if DriverName = nil then getmem(DriverName,strlen(temp)+1);
    strcopy(DriverName,temp);
    temp := StrTok(nil,',');
    if OutPutName = nil then getmem(OutPutName,strlen(temp)+1);
    StrCopy(OutPutName,temp);
    PrGetDefaults := true;
  end;
end;                           

{get printer details from common print dialog}
function PrGetCommDlg(var DeviceName:pchar;
                      var DriverName:pchar;
                      var OutputName:pchar): Boolean;
Var
  Info       : tPrintDlg;    {CommDlg print dialog information blocK}
  DevNames   : ^tDevNames;   {Driver descriptions information for commdlg}
  T          : pchar;
begin
  {Info is passed to the CommDlg.PrintDlg function}
  with Info do begin
    lStructSize := sizeof(tPrintDlg);    {size of structure}
    hWndOwner := getfocus;               {owner window}
    hDevMode  := 0;                      {PrintDlg will return this}
    hDevNames := 0;                      {ditto}
    Flags := pd_returndc;                {return a device context in hdc}
    if hWndOwner <> 0 then
      Flags := Flags + pd_showhelp;      { if we have a parent window then
                                           allow help button to be displayed in
                                           PrintDlg dialog}
    nMinPage := 1;                       {minimum page number allowable}
    nMaxPage := 9999;                    {max number of pages allowable}
    nFromPage := 1;                      {pages number from}
    nToPage := 1;                        {page number to}
    nCopies := 1;                        {default number of copies}
  end;
  if PrintDlg(Info) then begin
    DevNames := GlobalLock(Info.hDevNames); {get pointer to tDevNames structure}
    T := pchar(DevNames);
    Inc(T,Devnames^.wDeviceOffset);         {point at device name string}
    if DeviceName = nil then getmem(DeviceName,Strlen(t)+1);
    StrCopy(DeviceName,t);                  {set the device name}

    T := pchar(DevNames);
    Inc(T,Devnames^.wDriverOffset);         {point at driver name string}
    if DriverName = nil then getmem(DriverName,Strlen(t)+1);
    StrCopy(DriverName,t);                  {set the driver name}

    T := pchar(DevNames);
    Inc(T,Devnames^.wOutputOffset);         {point at output name string}
    if OutputName = nil then getmem(OutputName,Strlen(t)+1);
    StrCopy(OutputName,t);                  {set the Output name}

    with Info do begin
      GlobalUnLock(hDevNames); {free tDevNames structure}
      GlobalFree(hDevNames);
      GlobalFree(hDevMode);    {free tDevMode structure}
      DeleteDC(hDc);           {free the device context}
    end; {with}
    PrGetCommDlg := True;
  end else
    PrGetCommDlg := False;

end;

{initialise the print manager}
function PrStart(DocName,DeviceName,Drivername,OutPutName: PChar): Boolean;
begin

  gbPrinting := False;       {by default we are not gbPrinting}
  PrStart := False;          {by default return false}
  bAborted := false;          {by default we haven't bAborted yet}
  ghDc := CreateDc(DriverName,  {create the printer device context}
                   DeviceName,
                   OutputName,
                   nil);
  if ghDc <> 0 then begin
    gpAbortDiag := PAbort(Application^.MakeWindow(
                 New(PAbort, Init(Application^.MainWindow, gcpcAbortID))));
    if gpAbortDiag = nil then
      Application^.Error(em_OutOfMemory)
     else begin
      hAbortDiag := gpAbortDiag^.HWindow;
      gpAbortProc := MakeProcInstance(@AbortProc, HInstance);
      

      giEscResult := Escape(ghDc,SetAbortProc,0,gpAbortProc,nil);
      If (giEscResult>0) then begin
        giEscResult := Escape(ghDc,StartDoc,StrLen(DocName),
                            DocName,Nil);
        gbPrinting := (giEscResult>0);
        If gbPrinting then begin
          GetTextMetrics(ghDC,grTM);   {get page metrics}
          giPgWidth := getdevicecaps(ghDC,HorzRes);
          giPgHeight := getdevicecaps(ghDC,VertRes);
          giLnHeight := grTM.tmHeight + grTM.tmExternalLeading;
          giLnPerPage := giPgHeight div giLnHeight;
          giCurrLine := gciLinesAtTop;
        end; {if gbPrinting}
      end; {if giEscResult}
    end; {if abortdlg}  
  end; {if ghDc}
  if not gbPrinting then
  begin
    if gpAbortDiag <> nil then
      gpAbortDiag^.CloseWindow;
    BWCCMessageBox(getfocus,
      'Printer initialization failed', 'Error',
      mb_IconExclamation or mb_Ok)
  end;
  PrStart := gbPrinting
end;

{Send end of page to print manager}
function PrNewPage:boolean;
begin
  if gbPrinting and (giEscResult>0) then begin
    giEscResult := Escape(ghDc,Newframe,0,nil,nil);
    PrNewPage := giEscResult>0;
   end else
    PrNewPage := False;
end;

{Stop output to print manager and tell print manager to print}
function PrStop:boolean;
begin
  if gbPrinting then begin
    If (giCurrLine>gciLinesAtTop) then PrNewPage;
    if giEscResult>0 then
      Escape(ghDc,EndDoc,0,nil,nil);
    if gpAbortDiag <> nil then
      gpAbortDiag^.CloseWindow;
    gbPrinting := False;
    DeleteDC(ghDc);
    PrStop := True;
   end else
    PrStop := False;
end;

{send a line of text to the print manager}
function PrLine(Line : pChar):boolean; {print a line}
begin
  Inc(giCurrLine);
  PrLine := textout(ghDc,gciLMargin*grTM.tmAveCharWidth,giCurrLine*giLnHeight,Line,StrLen(Line));
  If giCurrLine >= (giLnPerPage-gciLinesAtBot) then begin
    PrLine := PrNewPage;
    giCurrLine := gciLinesAtTop;
  end;
end;

{force abort of print manager}
function PrAbort:boolean;
begin
end;

{sends a complete file to print manager and then prints it}
function PrFile(FileName : pchar;Dlg:Boolean):boolean;
var ret : boolean;
    F : text;
    S : string;
    P : pchar;
    Dn,Dv,Op : pchar;
begin
  Dn := nil;
  Dv := nil;
  Op := nil;
  If Dlg then
    ret := PrGetCommDlg(Dn,Dv,Op)    {allow user to choose printer}
   else
    ret := PrGetDefaults(Dn,Dv,Op);  {use windows default printer}
  if ret then begin
    if PrStart(FileName,Dn,Dv,Op) then begin
      assign(f,FileName);
      reset(F);
      getmem(P,256);
      while not eof(F) and ret do begin
        Readln(F,S);
        StrPCopy(P,S);
        ret := PrLine(P);
      end;
      Close(F);
      FreeMem(P,256);
      ret := PrStop;
    end;
    freemem(dn,strlen(dn)+1);
    freemem(dv,strlen(dv)+1);
    freemem(op,strlen(op)+1);
  end;
  PrFile := Ret;
end;

(************************* TAbort methods *****************************)

procedure TAbort.WMInitDialog(var Msg: TMessage);
begin
  SetFocus(HWindow)
end;

procedure TAbort.WMCommand(var Msg: TMessage);
begin
  bAborted := true;
end;

end.
