(**********************************************************************)
(*                               Keys                                 *)
(*                                                                    *)
(*                                                                    *)
(*  Author:  Geoffrey W. Moehrke                                      *)
(*  Date:  March 24, 1989                                             *)
(*                                                                    *)
(*  Purpose:  Module defining constants for misc keys and functions   *)
(*            to classify certain groups of related keys.             *)
(*                                                                    *)
(*  Source: F:\TP\UNIT\KEYS.PAS                                       *)
(**********************************************************************)
Unit Keys;

  Interface

  Const
     F1 = $3B00;    F6 = $4000;
     F2 = $3C00;    F7 = $4100;
     F3 = $3D00;    F8 = $4200;
     F4 = $3E00;    F9 = $4300;
     F5 = $3F00;   F10 = $4400;

     LArrow  = $4B00;
     RArrow  = $4D00;
     UpArrow = $4800;
     DnArrow = $5000;
     PgUp    = $4900;
     PgDn    = $5100;
     Home    = $4700;
     EndKey  = $4F00;
     Ins     = $5200;
     Del     = $5300;
     BS      = $0E08;
     Enter   = $1C0D;
     Tab     = $0F09;
     ShiftTab= $0F00;
     ESC     = $011B;

     Function EditKey( K : Word ): boolean;

     Function FuncKey( K : Word ): boolean;

   Implementation

     Function EditKey( K : Word ): boolean;

       begin
         Case K of
             LArrow, RArrow,
             Ins, Del,
             Home, EndKey,
             BS,
             Tab, ShiftTab  : EditKey := True;
           else EditKey := False
         end
       end;

     Function FuncKey( K : Word ): boolean;

       begin
         Case K of
             F1, F2,
             F3, F4,
             F5, F6,
             F7, F8,
             F9, F10 : FuncKey := True;
           else FuncKey := False
         end { Case }
       end;

end. { Unit Keys }