(*****************************************************************)
(*                           Unit TPClock                        *)
(*                                                               *)
(*  Author: Geoffrey Moehrke                                     *)
(*  Date:   May 16, 1989                                         *)
(*                                                               *)
(*  Purpose: Allow display of on screen clock - unit sits on top *)
(*           of TPCRT and provides replacement for kbd routines  *)
(*           as well as exporting the procedure that displays    *)
(*           the date and time on screen.                        *)
(*                                                               *)
(*  Source: F:\TP\UNIT\TPCLOCK                                   *)
(*****************************************************************)
Unit TPClock;

  Interface

    const
      CalendarEnabled : boolean = False;  { Display the date }
      ClockEnabled : Boolean = False;     { Display the time }

      ClockTimeMask : String[20] = 'HH:mm:ss te'; { Mask for time }
      ClockDateMask : String[20] = 'MM/dd/yy';    { Mask for date }
      ClockSepStr   : String[20] = '  '; { string displays between time & date }

      ClockX : byte = 59;   { Base coordinates for time/date display }
      ClockY : byte = 1;

    Var
      ClockAttr : Byte;     { Attribute for clock display            }

    procedure ShowClock;
      { Show clock on screen }

   { Replacements for TPCRT routines - each calls <ShowClock> then
     the corresponding routine from TPCRT.                          }

    Function KeyPressed : boolean;
    Function ReadKeyWord : Word;
    Function CheckKbd(var KeyCode : Word) : boolean;
    Function ReadKey : char;

 Implementation

   Uses
     TPDate,
     TPCRT;

  procedure ShowClock;

  begin
    if CalendarEnabled then
      FastWrite( TodayString(ClockDateMask),
                 ClockY, ClockX, ClockAttr );
    if ClockEnabled then
      FastWrite( ClockSepStr + CurrentTimeString( ClockTimeMask ),
                 ClockY, ClockX+Length(ClockDateMask), ClockAttr);
  end;


  Function Keypressed : boolean;

    begin
      ShowClock;
      KeyPressed := TPCRT.KeyPressed;
    end;

  Function ReadKeyWord : Word;

    begin
        repeat
          { do nothing }
        until Keypressed;
      ReadKeyWord := TPCRT.ReadKeyWord;
    end;

  Function CheckKbd( Var KeyCode : Word ): Boolean;

    begin
      ShowClock;
      CheckKbd := TPCRT.CheckKbd( KeyCode );
    end;

  function ReadKey : char;

    begin
      repeat
        { do nothing }
      until Keypressed;
      ReadKey := TPCRT.ReadKey;
    end;


begin
  ClockAttr := TextAttr;
end.