(**********************************************************************)
(*                        Unit IOError                                *)
(*                                                                    *)
(*                                                                    *)
(*  Author:  Geoffrey W. Moehrke                                      *)
(*  Date:  September 24, 1988                                         *)
(*                                                                    *)
(*  Purpose:  Exports a function to return a string based on the      *)
(*            error number passed as a parameter.                     *)
(*                                                                    *)
(*  Source: F:\TP\UNIT\IOERROR.PAS                                    *)
(**********************************************************************)
Unit IOError;

  Interface

    Type
      IOErrStr = String[35];

    function IOErrorMsg(Number: Integer):IOErrStr;


  Implementation

  function IOErrorMsg(Number: Integer):IOErrStr;

  begin
    case Number of
        2 : IOErrorMsg := 'Invalid file name or file not found';
        3 : IOErrorMsg := 'Path not found';
        4 : IOErrorMsg := 'Too many open files';
        5 : IOErrorMsg := 'File access denied';
        6 : IOErrorMsg := 'Invalid file handle';
       12 : IOErrorMsg := 'Invalid file access code';
       15 : IOErrorMsg := 'Invalid drive number';
       16 : IOErrorMsg := 'Cannot remove current directory';
       17 : IOErrorMsg := 'Cannot rename across drives';
      100 : IOErrorMsg := 'Disk read error';
      101 : IOErrorMsg := 'Disk write error';
      102 : IOErrorMsg := 'File not assigned';
      103 : IOErrorMsg := 'File not open';
      104 : IOErrorMsg := 'File not open for input';
      105 : IOErrorMsg := 'File not open for output';
      106 : IOErrorMsg := 'Invalid numeric format';
      150 : IOErrorMsg := 'Disk is write-protected';
      151 : IOErrorMsg := 'Unknown unit';
      152 : IOErrorMsg := 'Drive not ready';
      153 : IOErrorMsg := 'Unknown command';
      154 : IOErrorMsg := 'CRC error in data';
      155 : IOErrorMsg := 'Bad drive request structure length';
      156 : IOErrorMsg := 'Disk seek error';
      157 : IOErrorMsg := 'Unknown media type';
      158 : IOErrorMsg := 'Sector not found';
      159 : IOErrorMsg := 'Printer out of paper';
      160 : IOErrorMsg := 'Device write fault';
      161 : IOErrorMsg := 'Device read fault';
      162 : IOErrorMsg := 'Hardware failure';
   end;
 end;


end. { Unit IOError }