Unit HashTabl;
{$R-,S-,V-}

{ This Unit demonstrates the correct method of implementation for }
{ descendent Hash Tables, Using the Generic Hash Table defined in }
{ Unit GenTable.                                                  }

INTERFACE

Uses GenTable;

Type
  DataRec = Record
              Symb : String;  {Symbol string: assumed all uppercase}
              Addr : Word;    {Symbol Address where found in source}
              Line : Word;    {Line Number where found in source   }
            End;

  SymbolTable = Object (HTable)

                Data : DataRec;

                Procedure Create;
                Procedure Enter (TheKey : String; D : DataRec;
                                      Var Duplicate : Boolean);
                Procedure Retrieve (TheKey : String; Var Found : Boolean;
                                     Var D : DataRec);
{
  (* HTable methods which apply *)

                Procedure Destroy;
}
              End;

IMPLEMENTATION

Procedure SymbolTable.Create;  { Instantiates a Generic HashTable }
                               { Using DataRec as the stored Data }
Begin
  HTable.Create (SizeOf(DataRec))
End;

Procedure SymbolTable.Enter (TheKey : String; D : DataRec;
                                  Var Duplicate : Boolean);

{ Enters a DataRec into the HashTable. Use D.Symb as TheKey}

Var
  Temp : EntryRec;
Begin
  Temp.Create ('');
  Temp.Init (SizeOf (DataRec));
  Temp.Set_Data (D,SizeOf (D));
  Temp.Key := TheKey;
  HTable.Enter (Temp,Duplicate);
  Temp.Destroy
End;

Procedure SymbolTable.Retrieve (TheKey : String; Var Found : Boolean;
                                 Var D : DataRec);

{ Retrieves a DataRec from the HashTable (If Found). If Not Found, }
{ D will be undefined (or will still contain old Data).            }

Var
  Temp : EntryRec;
Begin
  HTable.Retrieve (TheKey,Found,Temp);
  If Found Then
    Temp.Get_Data (D,SizeOf (D))
End;

BEGIN
END.