{************************************************}
{                                                }
{   Based on the Turbo Vision File Manager Demo  }
{   Copyright (c) 1992 by Borland International  }
{                                                }
{ Credits to Kim.K & Neil J. Rubenking for their }
{   work and suggestions which prompted me to    }
{   do it!                                       }
{                                                }
{ Any problems, etc. - mail me.                  }
{  Paul McManus, Jan 1994                        }
{  CIS 100113,225                                }
{                                                }
{************************************************}

Unit FViewer2;

{$F+,O+,X+,S-,D-}

Interface

Uses Objects, Views, Dos;

Const
  MaxIndex=2048;   { Max pointers into the file }

Type

  { TFileViewer }

  PFileViewer = ^TFileViewer;
  TFileViewer = Object(TScroller)
    FileName: PString;
    theFile : File;
    IsValid: Boolean;
    L:Array [1..MaxIndex] Of LongInt;      { pointers into the file }
    NumLines:Longint;                      { number of lines read }
    Gap,                                   { Gap between pointers }
    NL:Word;                               { Numper of pointers used }
    Constructor Init(Var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar;
      Const AFileName: PathStr);
    Constructor Load(Var S: TStream);
    Destructor Done; Virtual;
    Procedure Draw; Virtual;
    Procedure ReadFile(Const FName: PathStr);
    Procedure SetState(AState: Word; Enable: Boolean); Virtual;
    Procedure Store(Var S: TStream);
    Function Valid(Command: Word): Boolean; Virtual;
  End;

  { TTextWindow }

  PTextWindow = ^TTextWindow;
  TTextWindow = Object(TWindow)
    Constructor Init(R: TRect; Const FileName: PathStr);
  End;

Const

  RFileViewer: TStreamRec = (
     ObjType: 20080;
     VmtLink: Ofs(TypeOf(TFileViewer)^);
     Load:    @TFileViewer.Load;
     Store:   @TFileViewer.Store
  );
  RTextWindow: TStreamRec = (
     ObjType: 20081;
     VmtLink: Ofs(TypeOf(TTextWindow)^);
     Load:    @TTextWindow.Load;
     Store:   @TTextWindow.Store
  );

Procedure RegisterFViewer;

Implementation

Uses Drivers, Memory, MsgBox, App;

{ TFileViewer }
Constructor TFileViewer.Init(Var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar; Const AFileName: PathStr);
Begin
  Inherited Init(Bounds, AHScrollbar, AVScrollBar);
  GrowMode := gfGrowHiX + gfGrowHiY;
  FileName := NIL;
  ReadFile(AFileName);
End;

Constructor TFileViewer.Load(Var S: TStream);
Var
  FName: PathStr;
Begin
  Inherited Load(S);
  FileName := S.ReadStr;
  FName := FileName^;
  ReadFile(FName);
End;

destructor TFileViewer.Done;
Begin
  Close(theFile);
  DisposeStr(FileName);
  Inherited Done;
End;

Procedure TFileViewer.Draw;
Var
  B: TDrawBuffer;
  C: Byte;
  I: Integer;
  S: String;

  Buf:Array [1..2048] Of Char;     { Needed to read the file }
  NumRead,p,p1:word;

  Procedure TSeek(s:word);
  { Procedure to seek to line 's' in the file }
  Var i:Integer;
  Begin
    If s<=Gap
      Then { We've moved up to the start of the file }
        Reset(theFile,1)
      Else { Move to the nearest pointer position before the line we need }
        Seek(theFile,L[(s-1) DIV Gap]);
    {$I-}
    BlockRead(theFile,Buf,SizeOf(Buf),NumRead);
    {$I+}
    { Just check that we don't need to skip any lines because the pointer }
    { position was before the line we needed.  NB You may need to increase }
    { the size of Buf for files with long lines and large gaps between }
    { pointers; or include in the loop below a BlockRead when 'p' exceeds }
    { the length of Buf. }
    p:=1;
    For i:=1 To (s-1) MOD Gap Do
    Begin
      While Buf[p]<>#10 Do Inc(p);
      Inc(p);
    End;
  End;

  Procedure CheckBuf;
  { This procedure check to see if the end of the next line is beyond }
  { the end of Buf, in which case it gets the next block of data from }
  { the file }
  Begin
    If p>NumRead Then
    Begin
      {$I-}
      BlockRead(theFile,Buf,SizeOf(Buf),NumRead);
      {$I+}
      p:=1;
      If NumRead=0 Then Buf[1]:=#10; { if we've finished fake it! }
    End;
  End;

Begin
  Desktop^.Lock;                              { Freeze the screen }
  C := GetColor(1);
  If Delta.Y<NumLines Then TSeek(Delta.Y+1);  { Go to the right position }
  For I := 0 To Size.Y - 1 Do                 { draw each line ... }
  Begin
    MoveChar(B, ' ', C, Size.X);
    If Delta.Y + I <= NumLines Then           { is there a line to be drawn? }
    Begin
      s:='';
      While Buf[p]<>#10 Do
      Begin
        { Move the chars from the file buffer to the window buffer }
        p1:=p;
        While (Buf[p]<>#13) And (p<=NumRead) Do Inc(p);
        Move(Buf[p1],s[length(s)+1],p-p1);
        Inc(s[0],p-p1);
        IF Buf[p]=#13 THEN Inc(p);

        CheckBuf;
      End;
      Inc(p);
      CheckBuf;
      S := Copy(S, Delta.X + 1, Size.X);
      MoveStr(B, S, C);
    End;
    WriteLine(0, I, Size.X, 1, B);
  End;
  Desktop^.Unlock;
End;

Procedure TFileViewer.ReadFile(Const FName: PathStr);
Var
  MaxWidth: Integer;                { Count of max line width for scrollbar }
  Buf:Array [1..2048] Of Char;      { buffer for file reads }
  NumRead,                          { Valid buffer length }
  i,                                { index }
  GapDelta:Word;                    { Count of lines to skip before next }
                                    { pointer needs to be stored }
  LineLen,                          { Temp for current line length }
  LastOffset,                       { previous line start }
  Offset:LongInt;                   { current position in file }
  LastCh:Char;                      { fudge for eoln }

  Procedure AddLineStart(Offset:LongInt; Var GapDelta:Word);
  Var i:Word;
  Begin
    Inc(GapDelta);
    Inc(NumLines);
    If GapDelta=Gap Then
    Begin
      If NL=MaxIndex Then
      Begin { table is full And we need more space so pack it by two }
        For i:=1 To MaxIndex DIV 2 Do L[i]:=L[i*2];
        NL:=NL DIV 2;
        Gap:=Gap*2;
      End;
      If GapDelta=Gap Then { Just make sure }
      Begin
        Inc(NL);
        L[NL]:=Offset;
        GapDelta:=0;
      End;
    End;
  End;

Begin
  IsValid := True;
  If FileName <> NIL Then
  Begin
    Close(theFile);
    DisposeStr(FileName);
  End;
  FileName := NewStr(FName);
  {$I-}
  Assign(theFile, FName);
  Reset(theFile,1);
  If IOResult <> 0 Then
  Begin
    MessageBox('Cannot open file '+FName+'.', NIL, mfError + mfOkButton);
    IsValid := False;
  End
  Else
  Begin
    MaxWidth := 40;
    FillChar(L,SizeOf(L),0);
    NL:=0;
    NumLines:=0;
    LastOffset:=1;
    Gap:=1;
    GapDelta:=0;
    Offset:=0;
    Repeat
      BlockRead(theFile,Buf,SizeOf(Buf),NumRead);

      { Check each char read for the end of line }
      For i:=1 To NumRead Do
        If Buf[i]=#10 Then
        BEGIN
          { found the end of a new line so update the pointer array }
          AddLineStart(Offset+i,GapDelta);

          { Calculate line length to limit the scrollbar movement }
          LineLen:=Offset+i-LastOffset;
          IF LineLen>MaxWidth THEN MaxWidth:=LineLen;
          LastOffset:=Offset+i+2{ Skip CRLF };
        END;
      If NumRead<>0 Then LastCh:=Buf[NumRead];
      Inc(Offset,Numread);
    Until NumRead=0;
    If LastCh<>#10 Then Inc(NumLines);
  End;
  {$I+}
  Limit.X := MaxWidth;
  Limit.Y := NumLines;
End;

Procedure TFileViewer.SetState(AState: Word; Enable: Boolean);
Begin
  TScroller.SetState(AState, Enable);
  If Enable And (AState And sfExposed <> 0) Then
     SetLimit(Limit.X, Limit.Y);
End;

Procedure TFileViewer.Store(Var S: TStream);
Begin
  TScroller.Store(S);
  S.WriteStr(FileName);
End;

Function TFileViewer.Valid(Command: Word): Boolean;
Begin
  Valid := IsValid;
End;

{ TTextWindow }
Constructor TTextWindow.Init(R: TRect; Const FileName: PathStr);
Begin
  Inherited Init(R, Filename, wnNoNumber);
  Options := Options Or ofTileable;
  GetExtent(R);
  R.Grow(-1, -1);
  Insert(New(PFileViewer, Init(R,
    StandardScrollBar(sbHorizontal + sbHandleKeyboard),
    StandardScrollBar(sbVertical + sbHandleKeyboard), Filename)));
End;

Procedure RegisterFViewer;
Begin
  RegisterType(RFileViewer);
  RegisterType(RTextWindow);
End;

End.
