{$A+,B-,E+,F-,I-,N-,O-,R-,S-,V-}

UNIT FastWait;
(*	 Version 1.00 - 4/8/91	*)

{$IfDef DEBUG}
	{$D+,L+}
{$Else}
	{$D-,L-}
{$EndIf}


{}
INTERFACE

	VAR
WaitOneMS		: word;		{number of loops to do for 1 ms wait}
LoopsPerTick	: LongInt;	{number of loops per timer tick}
BIOSTick		: LongInt absolute $40:$6C;	{system timer, 18.2/second}


procedure Wait( ms	: word );
{
	Pauses execution of the program for "ms" milliseconds.
}


{$IfNDef VER40}	{$IfNDef VER50}	{$IfNDef VER55}
procedure ShortDelay(NumLoops : word);
{
  This procedure is for very short timing loops ( < 1ms) that cannot be
  handled by the delay routine.

  The variable "LoopsPerTick" has the number of loops to do for one BIOS
  tick (18.2 of these/sec). If you want to delay for "X" s, the number of loops
  required would be  "(LoopsPerTick*X) div 54945"

  This will not compile if you are using TP 4.0, 5.0 or 5.5 due to the
  conditional defines.  This is because it makes use of the "asm" statement
  which is not available in TP versions prior to 6.0.
}
{$EndIf}	{$EndIf}	{$EndIf}



{}
IMPLEMENTATION

{$L WAIT.OBJ}

procedure Wait( ms : word );	external;

procedure WaitInit;			external;

{$IfNDef VER40}	{$IfNDef VER50}	{$IfNDef VER55}
procedure ShortDelay(NumLoops : word); assembler;
asm
     mov  cx,NumLoops
     jcxz @@2
     xor  di,di         {ES:DI points to dummy address}
     mov  es,di         { which won't change}
     mov  al,es:[di]    {AL has the value there}
@@1:
     cmp  al,es:[di]
     jne  @@2
	loop @@1
@@2:
end;
{$EndIf}	{$EndIf}	{$EndIf}




begin		{Code to execute at start-up to calibrate the loop delay}
WaitInit;
end.
