Program Demo2;

{***************************************************************************
Purpose:  To demonstrate the advantages of FASTKEY over the standard method
          of checking the keyboard.
***************************************************************************}

Uses
  Crt,FastKey;

Const
  Y = 20;

Var
  X                    { Current location of the "ship" }
         : Integer;

Begin
  ClrScr;
  writeln ('FastKey Demonstration - After FastKey is installed.  Press Esc to exit.');
  X := 40;                                  { set initial location of ship }
  InstallFastKey;                           { prepare to use FastKey }
  repeat
    GotoXY(X,Y);  write('X');               { display the ship }
    if Pressed(FKLeft) and not Pressed(FKRight) then Begin
      GotoXY(X,Y);  write(' ');             { erase the ship }
      if X > 1 then Dec(X);                 { update ship location }
    End else if Pressed(FKRight) and not Pressed(FKLeft) then Begin
      GotoXY(X,Y);  write(' ');             { erase the ship }
      if X<80 then Inc(X);                  { update location of ship }
    End;
  until Pressed(FKEsc);
  UnInstallFastKey;                         { remove FastKey from memory }
  Clrscr;
End. {Demo 2}