Program Demo1;

{***************************************************************************
Purpose:  To demonstrate how Turbo Pascal (and nearly any other DOS app)
          handles the keyboard.
***************************************************************************}

Uses
  Crt;

Const
  Esc   = #27;         { Scan codes used for keys by the program }
  Left  = #75;
  Right = #77;
  Y = 20;

Var
  Key                  { Used to track the keys that are pressed }
         : Char;
  X                    { Current location of the "ship" }
         : Integer;

Begin
  ClrScr;
  writeln ('FastKey Demonstration - Before FastKey is installed.  Press Esc to exit.');
  X := 40;                                  { set initial location of ship }
  repeat
    GotoXY(X,Y);  write('X');               { display the ship }
    Key := ReadKey;                         { get any key pressed }
    if Key = #0 then Begin                  { handle any ship movement }
      Key := ReadKey;                       { get the extended function key }
      if Key = Left then Begin              { move the ship left }
        GotoXY(X,Y);  write(' ');           { erase the ship }
        if X > 1 then Dec(X);               { update ship location }
      End else if Key = Right then Begin    { move the ship right }
        GotoXY(X,Y);  write(' ');           { erase the ship }
        if X<80 then Inc(X);                { update location of ship }
      End;
    End;
  until Key = Esc;
  ClrScr;
End. {Demo 1}