{------------------------

This file demonstrates how to create both a window and a dialog
from within a DLL. To use it, copy the following .RC text into a
file named APIDLL.RC:

AboutBox DIALOG 18, 18, 142, 92
STYLE DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU
CAPTION "About APIDLL"
BEGIN
CONTROL "Copyright C 1994 Borland International", -1, "STATIC", SS_LEFT | WS_CHILD | WS_VISIBLE | WS_GROUP, 8, 13, 126, 22
CONTROL "OK", 1, "BUTTON", BS_DEFPUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, 59, 39, 24, 14
END

From within Resource Workshop, choose File | Open and select
APIDLL.RC. Then choose File | Save As and select APIDLL.RES.

Then copy this program into a file named APITest.PAS and compile
both it and the DLL listed further down:

program APITest;

procedure WinMainApi; far; external 'ApiDLL';

begin
  WinMainApi;
end.
------------------------}

Library ApiDll;

uses WinTypes, WinProcs, Strings;

const
  AppName = 'Generic';

{$R APIDll.Res}

const
  idm_About = 100;

function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
begin
  About := True;
  case Message of
    wm_InitDialog:
      Exit;
    wm_Command:
      if (WParam = id_Ok) or (WParam = id_Cancel) then
      begin
        EndDialog(Dialog, 1);
        Exit;
      end;
  end;
  About := False;
end;

procedure HandleButton(Window: HWnd);
begin
  MessageBox(Window, 'Hello', 'Sam', MB_OK);
end;

function WindowProc(Window: HWnd; Message, WParam: Word; LParam: Longint): Longint; export;
const
  S:PChar = 'Hello from the DLL';
  S1:PChar = 'Try clicking left button, or right button';
var
  PS: TPaintStruct;
  PaintDC: HDC;

begin
  WindowProc := 0;
  case Message of
    wm_Destroy:
      begin
        PostQuitMessage(0);
        Exit;
      end;
    wm_LButtonDown: begin
      HandleButton(Window);
      Exit;
    end;

    wm_RButtonDown: begin
      DialogBox(HInstance, 'AboutBox', Window, @About);
      Exit;
    end;


    wm_Paint: begin
      PaintDC := BeginPaint(Window, PS);
        TextOut(PaintDC, 10, 10, S, strlen(S));
        TextOut(PaintDC, 10, 50, S1, strlen(S1));
      EndPaint(Window, PS);
    end;
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam);
end;

procedure WinMainApi; export;
var
  Window: HWnd;
  Message: TMsg;
const
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: AppName;
    lpszClassName: AppName);
begin
  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := LoadIcon(0, idi_Application);
    WindowClass.hCursor := LoadCursor(0, idc_Arrow);
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    if not RegisterClass(WindowClass) then Halt(255);
  end;
  Window := CreateWindow(
    AppName,
    'Turbo Pascal Generic',
    ws_OverlappedWindow,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    0,
    0,
    HInstance,
    nil);
  CmdShow := Sw_ShowNormal;
  ShowWindow(Window, CmdShow);
  UpdateWindow(Window);
  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;
end;

exports
  WinMainApi index 1;
begin
end.
