
{****************************************************************************


       MatchStr: Public Domain, May 3, 1989. Written by Tom Guinther


****************************************************************************}




Unit MatchStr;



Interface



Function Match(S, MS : String) : Boolean;
Function MatchFileName(FileName, MS : String) : Boolean;



Implementation



Function Min(A, B : Byte) : Byte;
Begin

   If A < B then
    Min := A
   Else
    Min := B;

End;



{****************************************************************************

   Match: Match the string S to the string MS. MS may include the DOS 
          wildcard characters '*' and '?'.

****************************************************************************}

Function Match(S, MS : String) : Boolean;
Var
  I,
  MinLen : Byte;
  Done   : Boolean;

Begin

  Match := False;

  I      := 0;
  MinLen := Min(Length(S),Length(MS));
  Done   := False;

  While((NOT Done) and (I < MinLen)) Do
  Begin

       Inc(I);

       Case(MS[I]) of

         '*' : Done := True;
         '?' : ;

         Else
           If MS[i] <> S[I] Then
             Exit;


       End;

  End;

  Match := True;


End;



{****************************************************************************

  MatchFileName:

     Match the string FileName against the spec string MS. MS may contain
     the DOS wildcard characters '*' and '?'.

     Examples   MatchFileName('TEST.PAS','*.?as') = True;
                MatchFileName('TEST','*.')        = True;
                MatchFileName('TEST.C','T*.*')    = True;

****************************************************************************}

Function MatchFileName(FileName, MS : String) : Boolean;
Var
  Name,
  Ext,
  MSName,
  MSExt    : String;

  P        : Byte;

  Result   : Boolean;

Begin

  Result := True;  { Assume the best since we will be using a Boolean AND }


  { Prep the file name }

  P := Pos('.',FileName);

  If P = 0 Then
    P := Length(FileName)+1;

  Name := Copy(FileName,1,P-1);
  Ext  := Copy(FileName,P+1,3);


  { Prep Search String }

  P := Pos('.',MS);

  If P = 0 Then
    P := Length(FileName)+1;

  MSName := Copy(MS,1,P-1);
  MSExt  := Copy(MS,P+1,3);


  {*******************************************************************

    Special Cases:

            1)  Looking for *. and file has valid extension,
                which will result in Match = False. But,
                this is actually a valid DOS match.

            2)  Looking for *.* or *.? etc when filename doesn't
                have an extension. Match = False, but assuming that
                MSExt is entirly made up of wildcards, we have a
                valid DOS match.

    Result:

            If either MSext or Ext are empty ('') then they are
            set = to 3 spaces ('   '); this gaurentees that both
            cases will return the proper results.


  ********************************************************************}

  If Length(Ext) = 0 Then
    Ext := '   ';

  If Length(MSExt) = 0 Then
    MSExt := '   ';

  Result := Match(Name,MSName);

  If (Result) Then
    Result := Result and Match(Ext,MSExt);

  MatchFileName := Result;

End;



End.  { Implementation }
