/*
	tree.c -- treesort 3, an in-place variant of heapsort
		
	Robert W. Floyd, CACM, Algorithm 245
	See Harold Lorin, "Sorting and Sort Systems," Appendix A, p28.
*/
#include "demosort.h"

static void
siftup(char *a, register int i, int n, int speed_factor);

void
tree(char *a, int n, int speed_factor)
{
	register int i;

	for (i = n/2; i >= 1; --i)
		siftup(a, i, n, speed_factor);
	for (i = n - 1; i >= 1; --i)
	{
		siftup(a, 0, i, speed_factor);
		if (slowdown(speed_factor) == 1)
			return;	/* user hit ctl-break */
		exchange(a, 0, 2 * i);
	}
}

static void
siftup(char *a, register int i, int n, int speed_factor)
{
	char c;
	register int j;

	c = a[2 * i];
loop:
	if (slowdown(speed_factor) == 1)
		return;	/* user hit ctl-break */
	j = 2 * i;
	if (j <= n)
	{
		if (j < n)
		{
			if (a[2 * (j + 1)] > a[2 * j])
			{
				++j;
			}
			if (a[2 * j] > c)
			{
				a[2 * i] = a[2 * j];
				i = j;
				goto loop;
			}
		}
	}
	a[2 * i] = c;
}
