/*
	shuttle.c -- shuttle sort
		
	See Harold Lorin, "Sorting and Sort Systems," Appendix B.
	From CACM, Vol 6, #6, p312.
*/

#include "demosort.h"

void
shuttle(char *p, int n, int speed_factor)
{
	register int i, j;

	for (i = 0; i < n - 1; ++i)
		for (j = i; j >= 0; --j)
		{
			if (p[2 * j] <= p[2 * (j + 1)])
				break;
			if (slowdown(speed_factor) == 1)
				return;	/* user hit ctl-break */
			exchange(p, 2 * j, 2 * (j + 1));
		}
}
