/* shell.c -- shell sort */

#include "demosort.h"

void
shell(char *p, int n, int speed_factor)
{
	int limit, distance;
	register int i, j;

	distance = n / 2;
	while (distance)
	{
		limit = n - distance;
		for (j = 0; j < limit; ++j)
			for (i = j; i >= 0; i -= distance)
			{
				if (p[2 * (i + distance)] >= p[2 * i])
					break;
				if (slowdown(speed_factor) == 1)
					return;	/* user hit ctl-break */
				exchange(p, 2 * i, 2 * (i + distance));
			}
		distance /= 2;
	}
}
