/*
	rex.c -- radix exchange sort.
		
	See Robert Sedgewick, ALGORITHMS, page 117.
*/

#include "demosort.h"
#define STATIC static

STATIC void rex(unsigned char *a, int l, int r, int b, int slowdown_factor);

void
radix(unsigned char *ptr, int n, int slowdown_factor)
{
      rex(ptr, 1, n, 6, slowdown_factor);
}

/*
   Initial call: rex(buf, 0, size - 1, 7)

   (Because 7 is highest bit to sort on.)
*/
STATIC void
rex(unsigned char *a, int l, int r, int b, int slowdown_factor)
{
	unsigned char t;
	register int i, j;

	if (r > l && b >= 0)
	{
		i = l;
		j = r;
		do
		{
			while((!(a[2 * (i - 1)] & (unsigned char)(1 << b))) && i < j)
				++i;
			while(((a[2 * (j - 1)] & (unsigned char)(1 << b))) && i < j)
				--j;
			t = a[2 * (i - 1)];
			a[2 * (i - 1)] = a[2 * (j - 1)];
			a[2 * (j - 1)] = t;
			if (slowdown(slowdown_factor) == 1)
				return;	/* user hit ctl-break */
		}
		while (j > i)
			;
		if (!(a[2 * (r - 1)] & (unsigned char)(1 << b)))
			++j;
		rex(a, l, j - 1, b - 1, slowdown_factor);
		rex(a, j, r, b - 1, slowdown_factor);
	}
}
