/* quicker.c --  enhanced quicksort (provenance uncertain)  */

#include "demosort.h"

#define M 9

static void sift(char *p, int n);

void
quicker(char *a, int n, int speed_factor)
{
	char v;
	int stack[32];
	register int L = 0;
	register int i, j;
	register int p = 0;
	register int r;

	r = n - 1;
	while(1)
	{
		if (a[2 * L] > a[2 * r])
			exchange(a, 2 * L, 2 * r);
		if (a[2 * ((L + r) / 2)] > a[2 * r])
			exchange(a,2 * ((L + r)/2), 2 * r);
		if (a[2 * L] > a[2 * ((L + r)/2)])
			exchange(a, 2 * L,
			  2*((L + r)/2));
		if (slowdown(speed_factor) == 1)
			return;	/* user hit ctl-break */
		exchange(a, 2 * (L + 1), 2 * ((L + r)/2));
		i = L + 1;
		j = r;
		v = a[2 * (L + 1)];
		while(1)
		{
			while(a[++i * 2] < v)
				;
			while(a[--j * 2] > v)
				;
			if (i >= j)
				break;
			exchange(a, 2 * i, 2 * j);
		}
		if (slowdown(speed_factor) == 1)
			return;	/* user hit ctl-break */
		exchange(a, 2 * L, 2 * j);
		if (j - L > r - j)
		{
			if (M >= j - L)
			{
				if (p == 0)
					break;
				p -= 2;
				L = stack[p];
				r = stack[p + 1];
			}
			else
			{
				if (r - j > M)
				{
					stack[p] = L;
					stack[p + 1] = j - 1;
					p += 2;
					L = j + 1;
				}
				else
					r = j - 1;
			}
		}
		else
		{
			if (M >= r - j)
			{
				if (!p)
				{
					break;
				}
				p -= 2;
				L = stack[p];
				r = stack[p + 1];
			}
			else
			{
				if (j - L > M)
				{
					stack[p] = j + 1;
					stack[p + 1] = r;
					p += 2;
					r = j - 1;
				}
				else
					L = j + 1;
			}
		}
	}
	sift(a, n);
}

static void
sift(char *p, int n)
{
        register int i, j;
        char c;

        for (j = 1; j < n; ++j)
        {
                i = j - 1;
                c = p[2 * j];
                while(c < p[2 * i])
                        {
                        p[2 * (i + 1)] = p[2 * i];
                        if (--i < 0)
                                break;
                        } 
                p[2 * (i + 1)] = c;
        }
}

