/*
	med3.c

    Median-of-three quicksort.  Reference:

    Robert Sedgewick, QUICKSORT.  Garland Publishing, Inc.
    New York & London, 1980.  Page 206, program 8.1.
*/

#include "demosort.h"

#define M 2
#define STATIC static

STATIC void m3(int *p, int l, int r, int slowdown_factor);

void
med3(char *p, int n, int slowdown_factor)
{
	m3((int *)p, 0, n - 1, slowdown_factor);
}

STATIC void
m3(int *p, int l, int r, int slowdown_factor)
{
	register int i, j, v;

	if (r - l >= M)
	{
		if(p[l] > p[r])
			int_exchange(p, l, r);
		if(p[(l + r) / 2] > p[r])
			int_exchange(p, (l + r) / 2, r);
		if(p[l] > p[(l + r) / 2])
			int_exchange(p, l, (l + r) / 2);
		if (slowdown(slowdown_factor) == 1)
			return;	/* user hit ctl-break */
		int_exchange(p, p[l + 1], p[(l + r) / 2]);
		i = l;
		j = r + 1;
		v = p[l];
		while(1)
		{
			while(p[++i] < v)
				;
			while(p[--j] > v)
				;
			if (i >= j)
				break;
			int_exchange(p, i, j);
		}
		if (slowdown(slowdown_factor) == 1)
			return;	/* user hit ctl-break */
		int_exchange(p, l, j);
		m3(p, l, j - 1, slowdown_factor);
		m3(p, j + 1, r, slowdown_factor);
	}
}
